/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.agent.launcher.local")
@Validated
public class LocalAgentLauncherProperties {
    public static final String PROPERTY_PREFIX = "genie.agent.launcher.local";
    public static final String ENABLE_PROPERTY = "genie.agent.launcher.local.enabled";
    public static final String SERVER_PORT_PLACEHOLDER = "<SERVER_PORT_PLACEHOLDER>";
    public static final String JOB_ID_PLACEHOLDER = "<JOB_ID_PLACEHOLDER>";
    public static final String AGENT_JAR_PLACEHOLDER = "<AGENT_JAR_PLACEHOLDER>";
    private boolean enabled = true;
    @NotEmpty(message="The command-line launch template cannot be empty")
    private @NotEmpty(message="The command-line launch template cannot be empty") List<@NotBlank String> launchCommandTemplate = Lists.newArrayList((Object[])new String[]{"java", "-jar", "<AGENT_JAR_PLACEHOLDER>", "exec", "--server-host", "127.0.0.1", "--server-port", "<SERVER_PORT_PLACEHOLDER>", "--api-job", "--job-id", "<JOB_ID_PLACEHOLDER>"});
    @NotEmpty(message="The agent jar path cannot be empty")
    private @NotEmpty(message="The agent jar path cannot be empty") String agentJarPath = "/tmp/genie-agent.jar";
    private Map<@NotEmpty String, String> additionalEnvironment = Maps.newHashMap();
    private boolean processOutputCaptureEnabled;
    @Min(value=1L, message="The minimum value is 1MB but the value should likely be much higher")
    private @Min(value=1L, message="The minimum value is 1MB but the value should likely be much higher") int maxJobMemory = 10240;
    @Min(value=1L, message="The minimum value is 1MB but the value should likely be set much higher")
    private @Min(value=1L, message="The minimum value is 1MB but the value should likely be set much higher") long maxTotalJobMemory = 30720L;
    private boolean runAsUserEnabled;
    private Duration hostInfoExpireAfter = Duration.ofMinutes(1L);
    private Duration hostInfoRefreshAfter = Duration.ofSeconds(30L);

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<@NotBlank String> getLaunchCommandTemplate() {
        return this.launchCommandTemplate;
    }

    public String getAgentJarPath() {
        return this.agentJarPath;
    }

    public Map<@NotEmpty String, String> getAdditionalEnvironment() {
        return this.additionalEnvironment;
    }

    public boolean isProcessOutputCaptureEnabled() {
        return this.processOutputCaptureEnabled;
    }

    public int getMaxJobMemory() {
        return this.maxJobMemory;
    }

    public long getMaxTotalJobMemory() {
        return this.maxTotalJobMemory;
    }

    public boolean isRunAsUserEnabled() {
        return this.runAsUserEnabled;
    }

    public Duration getHostInfoExpireAfter() {
        return this.hostInfoExpireAfter;
    }

    public Duration getHostInfoRefreshAfter() {
        return this.hostInfoRefreshAfter;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setLaunchCommandTemplate(List<@NotBlank String> launchCommandTemplate) {
        this.launchCommandTemplate = launchCommandTemplate;
    }

    public void setAgentJarPath(String agentJarPath) {
        this.agentJarPath = agentJarPath;
    }

    public void setAdditionalEnvironment(Map<@NotEmpty String, String> additionalEnvironment) {
        this.additionalEnvironment = additionalEnvironment;
    }

    public void setProcessOutputCaptureEnabled(boolean processOutputCaptureEnabled) {
        this.processOutputCaptureEnabled = processOutputCaptureEnabled;
    }

    public void setMaxJobMemory(int maxJobMemory) {
        this.maxJobMemory = maxJobMemory;
    }

    public void setMaxTotalJobMemory(long maxTotalJobMemory) {
        this.maxTotalJobMemory = maxTotalJobMemory;
    }

    public void setRunAsUserEnabled(boolean runAsUserEnabled) {
        this.runAsUserEnabled = runAsUserEnabled;
    }

    public void setHostInfoExpireAfter(Duration hostInfoExpireAfter) {
        this.hostInfoExpireAfter = hostInfoExpireAfter;
    }

    public void setHostInfoRefreshAfter(Duration hostInfoRefreshAfter) {
        this.hostInfoRefreshAfter = hostInfoRefreshAfter;
    }
}

