/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.agent.apis.rpc.v4.endpoints;

import com.netflix.genie.common.internal.dtos.v4.converters.JobDirectoryManifestProtoConverter;
import com.netflix.genie.common.internal.dtos.v4.converters.JobServiceProtoConverter;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.proto.FileStreamServiceGrpc;
import com.netflix.genie.proto.HeartBeatServiceGrpc;
import com.netflix.genie.proto.JobKillServiceGrpc;
import com.netflix.genie.proto.JobServiceGrpc;
import com.netflix.genie.proto.PingServiceGrpc;
import com.netflix.genie.web.agent.apis.rpc.v4.endpoints.GRpcAgentFileStreamServiceImpl;
import com.netflix.genie.web.agent.apis.rpc.v4.endpoints.GRpcHeartBeatServiceImpl;
import com.netflix.genie.web.agent.apis.rpc.v4.endpoints.GRpcJobKillServiceImpl;
import com.netflix.genie.web.agent.apis.rpc.v4.endpoints.GRpcJobServiceImpl;
import com.netflix.genie.web.agent.apis.rpc.v4.endpoints.GRpcPingServiceImpl;
import com.netflix.genie.web.agent.apis.rpc.v4.endpoints.JobServiceProtoErrorComposer;
import com.netflix.genie.web.agent.services.AgentConnectionTrackingService;
import com.netflix.genie.web.agent.services.AgentJobService;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.properties.AgentFileStreamProperties;
import com.netflix.genie.web.properties.HeartBeatProperties;
import io.micrometer.core.instrument.MeterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@EnableConfigurationProperties(value={AgentFileStreamProperties.class, HeartBeatProperties.class})
public class AgentRpcEndpointsAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AgentRpcEndpointsAutoConfiguration.class);
    private static final int SINGLE_THREAD = 1;

    @Bean
    @ConditionalOnMissingBean(name={"heartBeatServiceTaskScheduler"})
    public TaskScheduler heartBeatServiceTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(1);
        return scheduler;
    }

    @Bean
    @ConditionalOnMissingBean(value={JobServiceProtoErrorComposer.class})
    public JobServiceProtoErrorComposer jobServiceProtoErrorComposer() {
        return new JobServiceProtoErrorComposer();
    }

    @Bean
    @ConditionalOnMissingBean(value={FileStreamServiceGrpc.FileStreamServiceImplBase.class})
    public GRpcAgentFileStreamServiceImpl gRpcAgentFileStreamService(JobDirectoryManifestProtoConverter converter, @Qualifier(value="genieTaskScheduler") TaskScheduler taskScheduler, AgentFileStreamProperties properties, MeterRegistry registry) {
        return new GRpcAgentFileStreamServiceImpl(converter, taskScheduler, properties, registry);
    }

    @Bean
    @ConditionalOnMissingBean(value={HeartBeatServiceGrpc.HeartBeatServiceImplBase.class})
    public GRpcHeartBeatServiceImpl gRpcHeartBeatService(AgentConnectionTrackingService agentConnectionTrackingService, HeartBeatProperties properties, @Qualifier(value="heartBeatServiceTaskScheduler") TaskScheduler taskScheduler, MeterRegistry registry) {
        return new GRpcHeartBeatServiceImpl(agentConnectionTrackingService, properties, taskScheduler, registry);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobKillServiceGrpc.JobKillServiceImplBase.class})
    public GRpcJobKillServiceImpl gRpcJobKillService(DataServices dataServices) {
        return new GRpcJobKillServiceImpl(dataServices);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobServiceGrpc.JobServiceImplBase.class})
    public GRpcJobServiceImpl gRpcJobService(AgentJobService agentJobService, JobServiceProtoConverter jobServiceProtoConverter, JobServiceProtoErrorComposer protoErrorComposer, MeterRegistry meterRegistry) {
        return new GRpcJobServiceImpl(agentJobService, jobServiceProtoConverter, protoErrorComposer, meterRegistry);
    }

    @Bean
    @ConditionalOnMissingBean(value={PingServiceGrpc.PingServiceImplBase.class})
    public GRpcPingServiceImpl gRpcPingService(GenieHostInfo genieHostInfo) {
        return new GRpcPingServiceImpl(genieHostInfo);
    }
}

