/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.agent.launchers;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.agent.launchers.impl.LocalAgentLauncherImpl;
import com.netflix.genie.web.agent.launchers.impl.TitusAgentLauncherImpl;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.introspection.GenieWebHostInfo;
import com.netflix.genie.web.introspection.GenieWebRpcInfo;
import com.netflix.genie.web.properties.LocalAgentLauncherProperties;
import com.netflix.genie.web.properties.TitusAgentLauncherProperties;
import com.netflix.genie.web.util.ExecutorFactory;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={LocalAgentLauncherProperties.class, TitusAgentLauncherProperties.class})
public class AgentLaunchersAutoConfiguration {
    @Bean
    @ConditionalOnProperty(name={"genie.agent.launcher.titus.enabled"}, havingValue="true")
    public TitusAgentLauncherImpl titusAgentLauncher(@Qualifier(value="titusRestTemplate") RestTemplate restTemplate, GenieHostInfo genieHostInfo, TitusAgentLauncherProperties titusAgentLauncherProperties, MeterRegistry registry) {
        Cache healthIndicatorCache = Caffeine.newBuilder().maximumSize((long)titusAgentLauncherProperties.getHealthIndicatorMaxSize()).expireAfterWrite(titusAgentLauncherProperties.getHealthIndicatorExpiration().getSeconds(), TimeUnit.SECONDS).build();
        return new TitusAgentLauncherImpl(restTemplate, (Cache<String, String>)healthIndicatorCache, genieHostInfo, titusAgentLauncherProperties, registry);
    }

    @Bean
    @ConditionalOnMissingBean(value={ExecutorFactory.class})
    public ExecutorFactory processExecutorFactory() {
        return new ExecutorFactory();
    }

    @Bean
    @ConditionalOnProperty(name={"genie.agent.launcher.local.enabled"}, havingValue="true")
    public LocalAgentLauncherImpl localAgentLauncher(GenieWebHostInfo genieWebHostInfo, GenieWebRpcInfo genieWebRpcInfo, DataServices dataServices, LocalAgentLauncherProperties launcherProperties, ExecutorFactory executorFactory, MeterRegistry registry) {
        return new LocalAgentLauncherImpl(genieWebHostInfo, genieWebRpcInfo, dataServices, launcherProperties, executorFactory, registry);
    }
}

