/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks.leader;

import com.google.common.collect.Sets;
import com.netflix.genie.web.tasks.leader.LeaderTask;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.integration.leader.event.AbstractLeaderEvent;
import org.springframework.integration.leader.event.OnGrantedEvent;
import org.springframework.integration.leader.event.OnRevokedEvent;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;

public class LeaderTasksCoordinator {
    private static final Logger log = LoggerFactory.getLogger(LeaderTasksCoordinator.class);
    private final Set<LeaderTask> tasks;
    private final Set<ScheduledFuture<?>> futures = Sets.newHashSet();
    private final TaskScheduler taskScheduler;
    private boolean isRunning;

    public LeaderTasksCoordinator(TaskScheduler taskScheduler, Collection<LeaderTask> tasks) {
        this.taskScheduler = taskScheduler;
        this.isRunning = false;
        this.tasks = Sets.newHashSet();
        if (tasks != null) {
            this.tasks.addAll(tasks);
        }
    }

    @PreDestroy
    public void preDestroy() {
        this.cancelTasks();
    }

    @EventListener
    public synchronized void onLeaderEvent(AbstractLeaderEvent leaderEvent) {
        if (leaderEvent instanceof OnGrantedEvent) {
            if (this.isRunning) {
                return;
            }
            log.info("Leadership granted.");
            this.isRunning = true;
            this.tasks.forEach(task -> {
                switch (task.getScheduleType()) {
                    case TRIGGER: {
                        Trigger trigger = task.getTrigger();
                        log.info("Scheduling leadership task {} to run with trigger {}", (Object)task.getClass().getCanonicalName(), (Object)trigger);
                        this.futures.add(this.taskScheduler.schedule((Runnable)task, trigger));
                        break;
                    }
                    case FIXED_RATE: {
                        long rate = task.getFixedRate();
                        log.info("Scheduling leadership task {} to run every {} second(s)", (Object)task.getClass().getCanonicalName(), (Object)((double)rate / 1000.0));
                        this.futures.add(this.taskScheduler.scheduleAtFixedRate((Runnable)task, rate));
                        break;
                    }
                    case FIXED_DELAY: {
                        long delay = task.getFixedDelay();
                        log.info("Scheduling leadership task {} to run at a fixed delay of every {} second(s)", (Object)task.getClass().getCanonicalName(), (Object)((double)delay / 1000.0));
                        this.futures.add(this.taskScheduler.scheduleWithFixedDelay((Runnable)task, delay));
                        break;
                    }
                    default: {
                        log.error("Unknown Genie task type {}", (Object)task.getScheduleType());
                    }
                }
            });
        } else if (leaderEvent instanceof OnRevokedEvent) {
            if (!this.isRunning) {
                return;
            }
            log.info("Leadership revoked.");
            this.isRunning = false;
            this.cancelTasks();
        } else {
            log.warn("Unknown leadership event {}. Ignoring.", (Object)leaderEvent);
        }
    }

    private void cancelTasks() {
        for (ScheduledFuture<?> future : this.futures) {
            log.info("Attempting to cancel thread {}", future);
            if (future.cancel(true)) {
                log.info("Successfully cancelled.");
                continue;
            }
            log.info("Failed to cancel.");
        }
        this.futures.clear();
        this.tasks.forEach(LeaderTask::cleanup);
    }
}

