/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks.leader;

import com.netflix.genie.web.events.GenieEventBus;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.integration.leader.event.OnGrantedEvent;
import org.springframework.integration.leader.event.OnRevokedEvent;

@ThreadSafe
public class LocalLeader {
    private static final Logger log = LoggerFactory.getLogger(LocalLeader.class);
    private final GenieEventBus genieEventBus;
    private final boolean isLeader;
    private final AtomicBoolean isRunning;

    public LocalLeader(GenieEventBus genieEventBus, boolean isLeader) {
        this.genieEventBus = genieEventBus;
        this.isLeader = isLeader;
        this.isRunning = new AtomicBoolean(false);
        if (this.isLeader) {
            log.info("Constructing LocalLeader. This node IS the leader.");
        } else {
            log.info("Constructing LocalLeader. This node IS NOT the leader.");
        }
    }

    @EventListener
    public void startLeadership(ContextRefreshedEvent event) {
        log.debug("Starting Leadership due to {}", (Object)event);
        this.start();
    }

    @EventListener
    public void stopLeadership(ContextClosedEvent event) {
        log.debug("Stopping Leadership due to {}", (Object)event);
        this.stop();
    }

    public void stop() {
        if (this.isRunning.compareAndSet(true, false) && this.isLeader) {
            log.info("Stopping Leadership");
            this.genieEventBus.publishSynchronousEvent((ApplicationEvent)new OnRevokedEvent((Object)this, null, "leader"));
        }
    }

    public void start() {
        if (this.isRunning.compareAndSet(false, true) && this.isLeader) {
            log.debug("Starting Leadership");
            this.genieEventBus.publishSynchronousEvent((ApplicationEvent)new OnGrantedEvent((Object)this, null, "leader"));
        }
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public boolean isLeader() {
        return this.isRunning() && this.isLeader;
    }
}

