/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.util;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.Executor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UNIXUtils {
    private static final Logger log = LoggerFactory.getLogger(UNIXUtils.class);
    private static final String SUDO = "sudo";

    private UNIXUtils() {
    }

    public static synchronized void createUser(String user, @Nullable String group, Executor executor) throws IOException {
        CommandLine idCheckCommandLine = new CommandLine("id").addArgument("-u").addArgument(user);
        try {
            executor.execute(idCheckCommandLine);
            log.debug("User already exists");
        }
        catch (IOException ioe) {
            boolean isGroupValid;
            log.debug("User does not exist. Creating it now.");
            boolean bl = isGroupValid = StringUtils.isNotBlank((CharSequence)group) && !group.equals(user);
            if (isGroupValid) {
                log.debug("Group and User are different so creating group now.");
                CommandLine groupCreateCommandLine = new CommandLine(SUDO).addArgument("groupadd").addArgument(group);
                try {
                    log.debug("Running command to create group:  [{}]", (Object)groupCreateCommandLine);
                    executor.execute(groupCreateCommandLine);
                }
                catch (IOException ioexception) {
                    log.debug("Group creation threw an error as it might already exist", (Throwable)ioexception);
                }
            }
            CommandLine userCreateCommandLine = new CommandLine(SUDO).addArgument("useradd").addArgument(user);
            if (isGroupValid) {
                userCreateCommandLine.addArgument("-G").addArgument(group);
            }
            userCreateCommandLine.addArgument("-M");
            log.debug("Running command to create user: [{}]", (Object)userCreateCommandLine);
            executor.execute(userCreateCommandLine);
        }
    }

    public static void changeOwnershipOfDirectory(String dir, String user, Executor executor) throws IOException {
        CommandLine commandLine = new CommandLine(SUDO).addArgument("chown").addArgument("-R").addArgument(user).addArgument(dir);
        executor.execute(commandLine);
    }
}

