/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.hateoas.assemblers;

import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.internal.exceptions.checked.GenieCheckedException;
import com.netflix.genie.web.apis.rest.v3.controllers.ApplicationRestController;
import com.netflix.genie.web.apis.rest.v3.controllers.ClusterRestController;
import com.netflix.genie.web.apis.rest.v3.controllers.CommandRestController;
import com.netflix.genie.web.apis.rest.v3.controllers.JobRestController;
import com.netflix.genie.web.apis.rest.v3.controllers.RootRestController;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;

public class RootModelAssembler
implements RepresentationModelAssembler<Map<String, String>, EntityModel<Map<String, String>>> {
    private static final String APPLICATIONS_LINK = "applications";
    private static final String COMMANDS_LINK = "commands";
    private static final String CLUSTERS_LINK = "clusters";
    private static final String JOBS_LINK = "jobs";

    @Nonnull
    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF_ALL_TARGETS_DANGEROUS"})
    public EntityModel<Map<String, String>> toModel(Map<String, String> metadata) {
        EntityModel rootResource = EntityModel.of(metadata);
        try {
            rootResource.add(WebMvcLinkBuilder.linkTo(((RootRestController)WebMvcLinkBuilder.methodOn(RootRestController.class, (Object[])new Object[0])).getRoot()).withSelfRel());
            rootResource.add(WebMvcLinkBuilder.linkTo(((ApplicationRestController)WebMvcLinkBuilder.methodOn(ApplicationRestController.class, (Object[])new Object[0])).createApplication(null)).withRel(APPLICATIONS_LINK));
            rootResource.add(WebMvcLinkBuilder.linkTo(((CommandRestController)WebMvcLinkBuilder.methodOn(CommandRestController.class, (Object[])new Object[0])).createCommand(null)).withRel(COMMANDS_LINK));
            rootResource.add(WebMvcLinkBuilder.linkTo(((ClusterRestController)WebMvcLinkBuilder.methodOn(ClusterRestController.class, (Object[])new Object[0])).createCluster(null)).withRel(CLUSTERS_LINK));
            rootResource.add(WebMvcLinkBuilder.linkTo(((JobRestController)WebMvcLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).submitJob(null, null, null, null)).withRel(JOBS_LINK));
        }
        catch (GenieException | GenieCheckedException ge) {
            throw new RuntimeException(ge);
        }
        return rootResource;
    }
}

