/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import java.net.URI;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.jobs.locations")
@Validated
public class JobsLocationsProperties {
    public static final String PROPERTY_PREFIX = "genie.jobs.locations";
    private static final String SYSTEM_TMP_DIR = System.getProperty("java.io.tmpdir", "/tmp/");
    @NotNull(message="Archives storage location is required")
    private @NotNull(message="Archives storage location is required") URI archives = URI.create("file://" + SYSTEM_TMP_DIR + "genie/archives/");
    @Deprecated
    @NotNull(message="Default job working directory is required")
    private @NotNull(message="Default job working directory is required") URI jobs = URI.create("file://" + SYSTEM_TMP_DIR + "genie/jobs/");

    public URI getArchives() {
        return this.archives;
    }

    @Deprecated
    public URI getJobs() {
        return this.jobs;
    }

    public void setArchives(URI archives) {
        this.archives = archives;
    }

    @Deprecated
    public void setJobs(URI jobs) {
        this.jobs = jobs;
    }
}

