/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.apis.rpc.servers;

import io.grpc.Server;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRpcServerUtils {
    private static final Logger log = LoggerFactory.getLogger(GRpcServerUtils.class);

    private GRpcServerUtils() {
    }

    public static int startServer(Server server) throws IllegalStateException {
        try {
            server.start();
            int port = server.getPort();
            log.info("Successfully started gRPC server on port {}", (Object)port);
            return port;
        }
        catch (IllegalStateException ise) {
            int port = server.getPort();
            log.info("Server already started on port {}", (Object)port);
            return port;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unable to start gRPC server on port " + server.getPort(), ioe);
        }
    }
}

