/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.apis.rpc.v4.endpoints;

import com.google.common.collect.Sets;
import com.netflix.genie.common.external.dtos.v4.AgentClientMetadata;
import com.netflix.genie.common.external.dtos.v4.ArchiveStatus;
import com.netflix.genie.common.external.dtos.v4.JobRequest;
import com.netflix.genie.common.external.dtos.v4.JobSpecification;
import com.netflix.genie.common.external.dtos.v4.JobStatus;
import com.netflix.genie.common.internal.dtos.v4.converters.JobServiceProtoConverter;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobNotFoundException;
import com.netflix.genie.proto.ChangeJobArchiveStatusRequest;
import com.netflix.genie.proto.ChangeJobArchiveStatusResponse;
import com.netflix.genie.proto.ChangeJobStatusRequest;
import com.netflix.genie.proto.ChangeJobStatusResponse;
import com.netflix.genie.proto.ClaimJobRequest;
import com.netflix.genie.proto.ClaimJobResponse;
import com.netflix.genie.proto.ConfigureRequest;
import com.netflix.genie.proto.ConfigureResponse;
import com.netflix.genie.proto.DryRunJobSpecificationRequest;
import com.netflix.genie.proto.GetJobStatusRequest;
import com.netflix.genie.proto.GetJobStatusResponse;
import com.netflix.genie.proto.HandshakeRequest;
import com.netflix.genie.proto.HandshakeResponse;
import com.netflix.genie.proto.JobServiceGrpc;
import com.netflix.genie.proto.JobSpecificationRequest;
import com.netflix.genie.proto.JobSpecificationResponse;
import com.netflix.genie.proto.ReserveJobIdRequest;
import com.netflix.genie.proto.ReserveJobIdResponse;
import com.netflix.genie.web.agent.apis.rpc.v4.endpoints.JobServiceProtoErrorComposer;
import com.netflix.genie.web.agent.services.AgentJobService;
import com.netflix.genie.web.util.MetricsUtils;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRpcJobServiceImpl
extends JobServiceGrpc.JobServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(GRpcJobServiceImpl.class);
    private static final String AGENT_VERSION_TAG = "agentVersion";
    private static final String STATUS_FROM_TAG = "statusFrom";
    private static final String STATUS_TO_TAG = "statusTo";
    private static final String UNKNOWN_VERSION = "unknown";
    private static final String TIMERS_PREFIX = "genie.rpc.job";
    private static final String HANDSHAKE_TIMER = "genie.rpc.job.handshake.timer";
    private static final String CONFIGURE_TIMER = "genie.rpc.job.configure.timer";
    private static final String RESERVE_TIMER = "genie.rpc.job.reserve.timer";
    private static final String RESOLVE_TIMER = "genie.rpc.job.resolve.timer";
    private static final String GET_SPECIFICATION_TIMER = "genie.rpc.job.getSpecification.timer";
    private static final String DRY_RUN_RESOLVE_TIMER = "genie.rpc.job.dryRunResolve.timer";
    private static final String CLAIM_TIMER = "genie.rpc.job.claim.timer";
    private static final String CHANGE_STATUS_TIMER = "genie.rpc.job.changeStatus.timer";
    private static final String GET_STATUS_TIMER = "genie.rpc.job.getStatus.timer";
    private static final String CHANGE_ARCHIVE_STATUS_TIMER = "genie.rpc.job.changeArchiveStatus.timer";
    private final AgentJobService agentJobService;
    private final JobServiceProtoConverter jobServiceProtoConverter;
    private final JobServiceProtoErrorComposer protoErrorComposer;
    private final MeterRegistry meterRegistry;

    public GRpcJobServiceImpl(AgentJobService agentJobService, JobServiceProtoConverter jobServiceProtoConverter, JobServiceProtoErrorComposer protoErrorComposer, MeterRegistry meterRegistry) {
        this.agentJobService = agentJobService;
        this.jobServiceProtoConverter = jobServiceProtoConverter;
        this.protoErrorComposer = protoErrorComposer;
        this.meterRegistry = meterRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshake(HandshakeRequest request, StreamObserver<HandshakeResponse> responseObserver) {
        HashSet tags = Sets.newHashSet();
        long start = System.nanoTime();
        try {
            AgentClientMetadata agentMetadata = this.jobServiceProtoConverter.toAgentClientMetadataDto(request.getAgentMetadata());
            tags.add(Tag.of((String)AGENT_VERSION_TAG, (String)agentMetadata.getVersion().orElse(UNKNOWN_VERSION)));
            this.agentJobService.handshake(agentMetadata);
            responseObserver.onNext((Object)HandshakeResponse.newBuilder().setMessage("Agent is allowed to proceed").setType(HandshakeResponse.Type.ALLOWED).build());
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoHandshakeResponse(e));
        }
        finally {
            this.meterRegistry.timer(HANDSHAKE_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(ConfigureRequest request, StreamObserver<ConfigureResponse> responseObserver) {
        HashSet tags = Sets.newHashSet();
        long start = System.nanoTime();
        try {
            AgentClientMetadata agentMetadata = this.jobServiceProtoConverter.toAgentClientMetadataDto(request.getAgentMetadata());
            tags.add(Tag.of((String)AGENT_VERSION_TAG, (String)agentMetadata.getVersion().orElse(UNKNOWN_VERSION)));
            Map<String, String> agentProperties = this.agentJobService.getAgentProperties(agentMetadata);
            responseObserver.onNext((Object)ConfigureResponse.newBuilder().putAllProperties(agentProperties).build());
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoConfigureResponse(e));
        }
        finally {
            this.meterRegistry.timer(CONFIGURE_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reserveJobId(ReserveJobIdRequest request, StreamObserver<ReserveJobIdResponse> responseObserver) {
        HashSet tags = Sets.newHashSet();
        long start = System.nanoTime();
        try {
            JobRequest jobRequest = this.jobServiceProtoConverter.toJobRequestDto(request);
            AgentClientMetadata agentClientMetadata = this.jobServiceProtoConverter.toAgentClientMetadataDto(request.getAgentMetadata());
            tags.add(Tag.of((String)AGENT_VERSION_TAG, (String)agentClientMetadata.getVersion().orElse(UNKNOWN_VERSION)));
            String jobId = this.agentJobService.reserveJobId(jobRequest, agentClientMetadata);
            responseObserver.onNext((Object)ReserveJobIdResponse.newBuilder().setId(jobId).build());
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoReserveJobIdResponse(e));
        }
        finally {
            this.meterRegistry.timer(RESERVE_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveJobSpecification(JobSpecificationRequest request, StreamObserver<JobSpecificationResponse> responseObserver) {
        HashSet tags = Sets.newHashSet();
        long start = System.nanoTime();
        try {
            String id = request.getId();
            JobSpecification jobSpec = this.agentJobService.resolveJobSpecification(id);
            responseObserver.onNext((Object)this.jobServiceProtoConverter.toJobSpecificationResponseProto(jobSpec));
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoJobSpecificationResponse(e));
        }
        finally {
            this.meterRegistry.timer(RESOLVE_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getJobSpecification(JobSpecificationRequest request, StreamObserver<JobSpecificationResponse> responseObserver) {
        HashSet tags = Sets.newHashSet();
        long start = System.nanoTime();
        try {
            String id = request.getId();
            JobSpecification jobSpecification = this.agentJobService.getJobSpecification(id);
            responseObserver.onNext((Object)this.jobServiceProtoConverter.toJobSpecificationResponseProto(jobSpecification));
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoJobSpecificationResponse(e));
        }
        finally {
            this.meterRegistry.timer(GET_SPECIFICATION_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveJobSpecificationDryRun(DryRunJobSpecificationRequest request, StreamObserver<JobSpecificationResponse> responseObserver) {
        HashSet tags = Sets.newHashSet();
        long start = System.nanoTime();
        try {
            JobRequest jobRequest = this.jobServiceProtoConverter.toJobRequestDto(request);
            JobSpecification jobSpecification = this.agentJobService.dryRunJobSpecificationResolution(jobRequest);
            responseObserver.onNext((Object)this.jobServiceProtoConverter.toJobSpecificationResponseProto(jobSpecification));
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Exception e) {
            log.error("Error resolving job specification for request " + request, (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoJobSpecificationResponse(e));
        }
        finally {
            this.meterRegistry.timer(DRY_RUN_RESOLVE_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void claimJob(ClaimJobRequest request, StreamObserver<ClaimJobResponse> responseObserver) {
        HashSet tags = Sets.newHashSet();
        long start = System.nanoTime();
        try {
            String id = request.getId();
            AgentClientMetadata clientMetadata = this.jobServiceProtoConverter.toAgentClientMetadataDto(request.getAgentMetadata());
            tags.add(Tag.of((String)AGENT_VERSION_TAG, (String)clientMetadata.getVersion().orElse(UNKNOWN_VERSION)));
            this.agentJobService.claimJob(id, clientMetadata);
            responseObserver.onNext((Object)ClaimJobResponse.newBuilder().setSuccessful(true).build());
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Exception e) {
            log.error("Error claiming job for request " + request, (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoClaimJobResponse(e));
        }
        finally {
            this.meterRegistry.timer(CLAIM_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeJobStatus(ChangeJobStatusRequest request, StreamObserver<ChangeJobStatusResponse> responseObserver) {
        HashSet tags = Sets.newHashSet();
        long start = System.nanoTime();
        try {
            String id = request.getId();
            JobStatus currentStatus = JobStatus.valueOf((String)request.getCurrentStatus().toUpperCase());
            JobStatus newStatus = JobStatus.valueOf((String)request.getNewStatus().toUpperCase());
            String newStatusMessage = request.getNewStatusMessage();
            tags.add(Tag.of((String)STATUS_FROM_TAG, (String)currentStatus.name()));
            tags.add(Tag.of((String)STATUS_TO_TAG, (String)newStatus.name()));
            this.agentJobService.updateJobStatus(id, currentStatus, newStatus, newStatusMessage);
            responseObserver.onNext((Object)ChangeJobStatusResponse.newBuilder().setSuccessful(true).build());
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Exception e) {
            log.error("Error changing job status for request " + request, (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoChangeJobStatusResponse(e));
        }
        finally {
            this.meterRegistry.timer(CHANGE_STATUS_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getJobStatus(GetJobStatusRequest request, StreamObserver<GetJobStatusResponse> responseObserver) {
        HashSet tags = Sets.newHashSet();
        long start = System.nanoTime();
        String id = request.getId();
        try {
            JobStatus status = this.agentJobService.getJobStatus(id);
            responseObserver.onNext((Object)GetJobStatusResponse.newBuilder().setStatus(status.name()).build());
            responseObserver.onCompleted();
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Exception e) {
            log.error("Error retrieving job {} status: {}", (Object)id, (Object)e.getMessage());
            MetricsUtils.addFailureTagsWithException(tags, e);
            responseObserver.onError((Throwable)e);
        }
        finally {
            this.meterRegistry.timer(GET_STATUS_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeJobArchiveStatus(ChangeJobArchiveStatusRequest request, StreamObserver<ChangeJobArchiveStatusResponse> responseObserver) {
        HashSet tags = Sets.newHashSet();
        long start = System.nanoTime();
        String id = request.getId();
        ArchiveStatus newArchiveStatus = ArchiveStatus.valueOf((String)request.getNewStatus());
        tags.add(Tag.of((String)STATUS_TO_TAG, (String)newArchiveStatus.name()));
        try {
            this.agentJobService.updateJobArchiveStatus(id, newArchiveStatus);
            responseObserver.onNext((Object)ChangeJobArchiveStatusResponse.newBuilder().build());
            responseObserver.onCompleted();
            MetricsUtils.addSuccessTags(tags);
        }
        catch (GenieJobNotFoundException e) {
            log.error("Cannot update archive status of job {}, job not found", (Object)id);
            MetricsUtils.addFailureTagsWithException(tags, e);
            responseObserver.onError((Throwable)Status.NOT_FOUND.withCause((Throwable)e).asException());
        }
        catch (Exception e) {
            log.error("Error retrieving job {} status: {}", (Object)id, (Object)e.getMessage());
            MetricsUtils.addFailureTagsWithException(tags, e);
            responseObserver.onError((Throwable)e);
        }
        finally {
            this.meterRegistry.timer(CHANGE_ARCHIVE_STATUS_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }
}

