/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.controllers;

import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.RootModelAssembler;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v3"})
public class RootRestController {
    private static final Logger log = LoggerFactory.getLogger(RootRestController.class);
    private final RootModelAssembler rootModelAssembler;
    private final Map<String, String> metadata;

    @Autowired
    public RootRestController(RootModelAssembler rootModelAssembler) {
        this.rootModelAssembler = rootModelAssembler;
        this.metadata = new HashMap<String, String>();
        this.metadata.put("description", "Genie V3 API");
    }

    @GetMapping(produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public EntityModel<Map<String, String>> getRoot() {
        return this.rootModelAssembler.toModel(this.metadata);
    }
}

