/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.entities;

import com.netflix.genie.web.data.services.impl.jpa.entities.BaseEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.CommandEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.FileEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.TagEntity;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.NamedSubgraph;
import javax.persistence.Table;

@Entity
@Table(name="applications")
@NamedEntityGraphs(value={@NamedEntityGraph(name="Application.commands", attributeNodes={@NamedAttributeNode(value="commands")}), @NamedEntityGraph(name="Application.commands.dto", attributeNodes={@NamedAttributeNode(value="commands", subgraph="command-sub-graph")}, subgraphs={@NamedSubgraph(name="command-sub-graph", attributeNodes={@NamedAttributeNode(value="executable"), @NamedAttributeNode(value="setupFile"), @NamedAttributeNode(value="configs"), @NamedAttributeNode(value="dependencies"), @NamedAttributeNode(value="tags"), @NamedAttributeNode(value="clusterCriteria", subgraph="criteria-sub-graph")}), @NamedSubgraph(name="criteria-sub-graph", attributeNodes={@NamedAttributeNode(value="tags")})}), @NamedEntityGraph(name="Application.dto", attributeNodes={@NamedAttributeNode(value="setupFile"), @NamedAttributeNode(value="configs"), @NamedAttributeNode(value="dependencies"), @NamedAttributeNode(value="tags")})})
public class ApplicationEntity
extends BaseEntity {
    public static final String COMMANDS_ENTITY_GRAPH = "Application.commands";
    public static final String COMMANDS_DTO_ENTITY_GRAPH = "Application.commands.dto";
    public static final String DTO_ENTITY_GRAPH = "Application.dto";
    private static final long serialVersionUID = -8780722054561507963L;
    @Basic
    @Column(name="type")
    private String type;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="applications_configs", joinColumns={@JoinColumn(name="application_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<FileEntity> configs = new HashSet<FileEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="applications_dependencies", joinColumns={@JoinColumn(name="application_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<FileEntity> dependencies = new HashSet<FileEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="applications_tags", joinColumns={@JoinColumn(name="application_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="tag_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<TagEntity> tags = new HashSet<TagEntity>();
    @ManyToMany(mappedBy="applications", fetch=FetchType.LAZY)
    private Set<CommandEntity> commands = new HashSet<CommandEntity>();

    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public void setConfigs(@Nullable Set<FileEntity> configs) {
        this.configs.clear();
        if (configs != null) {
            this.configs.addAll(configs);
        }
    }

    public void setDependencies(@Nullable Set<FileEntity> dependencies) {
        this.dependencies.clear();
        if (dependencies != null) {
            this.dependencies.addAll(dependencies);
        }
    }

    public void setTags(@Nullable Set<TagEntity> tags) {
        this.tags.clear();
        if (tags != null) {
            this.tags.addAll(tags);
        }
    }

    void setCommands(@Nullable Set<CommandEntity> commands) {
        this.commands.clear();
        if (commands != null) {
            this.commands.addAll(commands);
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public Set<FileEntity> getConfigs() {
        return this.configs;
    }

    public Set<FileEntity> getDependencies() {
        return this.dependencies;
    }

    public Set<TagEntity> getTags() {
        return this.tags;
    }

    public Set<CommandEntity> getCommands() {
        return this.commands;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "ApplicationEntity(super=" + super.toString() + ", type=" + this.type + ", dependencies=" + this.dependencies + ")";
    }
}

