/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.scripts;

import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.internal.util.PropertiesMapCache;
import com.netflix.genie.web.exceptions.checked.ResourceSelectionException;
import com.netflix.genie.web.properties.ClusterSelectorScriptProperties;
import com.netflix.genie.web.scripts.ResourceSelectorScript;
import com.netflix.genie.web.scripts.ResourceSelectorScriptResult;
import com.netflix.genie.web.scripts.ScriptManager;
import com.netflix.genie.web.selectors.ClusterSelectionContext;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSelectorManagedScript
extends ResourceSelectorScript<Cluster, ClusterSelectionContext> {
    private static final Logger log = LoggerFactory.getLogger(ClusterSelectorManagedScript.class);
    static final String CLUSTERS_BINDING = "clustersParameter";

    public ClusterSelectorManagedScript(ScriptManager scriptManager, ClusterSelectorScriptProperties properties, MeterRegistry registry, PropertiesMapCache propertyMapCache) {
        super(scriptManager, properties, registry, propertyMapCache);
    }

    @Override
    public ResourceSelectorScriptResult<Cluster> selectResource(ClusterSelectionContext context) throws ResourceSelectionException {
        log.debug("Called to attempt to select a cluster from {} for job {}", context.getClusters(), (Object)context.getJobId());
        return super.selectResource(context);
    }

    @Override
    protected void addParametersForScript(Map<String, Object> parameters, ClusterSelectionContext context) {
        super.addParametersForScript(parameters, context);
        parameters.put(CLUSTERS_BINDING, context.getClusters());
    }
}

