/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.selectors;

import com.google.common.collect.ImmutableSet;
import com.netflix.genie.common.external.dtos.v4.JobRequest;
import com.netflix.genie.common.external.dtos.v4.JobRequestMetadata;
import com.netflix.genie.web.agent.launchers.AgentLauncher;
import com.netflix.genie.web.dtos.ResolvedJob;
import com.netflix.genie.web.selectors.ResourceSelectionContext;
import java.util.Collection;
import java.util.Set;
import javax.validation.constraints.NotBlank;

public class AgentLauncherSelectionContext
extends ResourceSelectionContext<AgentLauncher> {
    private final JobRequestMetadata jobRequestMetadata;
    private final ResolvedJob resolvedJob;
    private final Set<AgentLauncher> agentLaunchers;

    public AgentLauncherSelectionContext(@NotBlank String jobId, JobRequest jobRequest, JobRequestMetadata jobRequestMetadata, ResolvedJob resolvedJob, Collection<AgentLauncher> agentLaunchers) {
        super(jobId, jobRequest, true);
        this.jobRequestMetadata = jobRequestMetadata;
        this.resolvedJob = resolvedJob;
        this.agentLaunchers = ImmutableSet.copyOf(agentLaunchers);
    }

    @Override
    public Set<AgentLauncher> getResources() {
        return this.agentLaunchers;
    }

    public JobRequestMetadata getJobRequestMetadata() {
        return this.jobRequestMetadata;
    }

    public ResolvedJob getResolvedJob() {
        return this.resolvedJob;
    }

    public Set<AgentLauncher> getAgentLaunchers() {
        return this.agentLaunchers;
    }

    @Override
    public String toString() {
        return "AgentLauncherSelectionContext(super=" + super.toString() + ", jobRequestMetadata=" + this.jobRequestMetadata + ", resolvedJob=" + this.resolvedJob + ", agentLaunchers=" + this.agentLaunchers + ")";
    }
}

