/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.selectors.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.netflix.genie.web.agent.launchers.AgentLauncher;
import com.netflix.genie.web.dtos.ResourceSelectionResult;
import com.netflix.genie.web.exceptions.checked.ResourceSelectionException;
import com.netflix.genie.web.scripts.AgentLauncherSelectorManagedScript;
import com.netflix.genie.web.scripts.ResourceSelectorScriptResult;
import com.netflix.genie.web.selectors.AgentLauncherSelectionContext;
import com.netflix.genie.web.selectors.AgentLauncherSelector;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptAgentLauncherSelectorImpl
implements AgentLauncherSelector {
    private static final Logger log = LoggerFactory.getLogger(ScriptAgentLauncherSelectorImpl.class);
    static final String SELECT_TIMER_NAME = "genie.jobs.agentLauncher.selectors.script.select.timer";
    private static final String NULL_TAG = "null";
    private static final String NULL_RATIONALE = "Script returned null, no preference";
    private final AgentLauncherSelectorManagedScript agentLauncherSelectorManagedScript;
    private final Set<AgentLauncher> agentLaunchers;
    private final MeterRegistry registry;

    public ScriptAgentLauncherSelectorImpl(AgentLauncherSelectorManagedScript agentLauncherSelectorManagedScript, Collection<AgentLauncher> agentLaunchers, MeterRegistry registry) {
        this.agentLauncherSelectorManagedScript = agentLauncherSelectorManagedScript;
        this.agentLaunchers = ImmutableSet.copyOf(agentLaunchers);
        this.registry = registry;
    }

    @Override
    public ResourceSelectionResult<AgentLauncher> select(@Valid AgentLauncherSelectionContext context) throws ResourceSelectionException {
        long selectStart = System.nanoTime();
        String jobId = context.getJobId();
        Set<AgentLauncher> resources = context.getAgentLaunchers();
        log.debug("Called to select agent launcher from {} for job {}", resources, (Object)jobId);
        HashSet tags = Sets.newHashSet();
        ResourceSelectionResult.Builder builder = new ResourceSelectionResult.Builder(this.getClass());
        try {
            ResourceSelectorScriptResult<AgentLauncher> result = this.agentLauncherSelectorManagedScript.selectResource(context);
            MetricsUtils.addSuccessTags(tags);
            Optional<AgentLauncher> agentLauncherOptional = result.getResource();
            if (!agentLauncherOptional.isPresent()) {
                String rationale = result.getRationale().orElse(NULL_RATIONALE);
                log.debug("No agent launcher selected due to: {}", (Object)rationale);
                tags.add(Tag.of((String)"agentLauncherClass", (String)NULL_TAG));
                builder.withSelectionRationale(rationale);
                ResourceSelectionResult<AgentLauncher> resourceSelectionResult = builder.build();
                return resourceSelectionResult;
            }
            AgentLauncher selectedAgentLauncher = agentLauncherOptional.get();
            tags.add(Tag.of((String)"agentLauncherClass", (String)selectedAgentLauncher.getClass().getSimpleName()));
            ResourceSelectionResult<AgentLauncher> resourceSelectionResult = builder.withSelectionRationale(result.getRationale().orElse(null)).withSelectedResource(selectedAgentLauncher).build();
            return resourceSelectionResult;
        }
        catch (Throwable e) {
            String errorMessage = "Agent launcher selection error: " + e.getMessage();
            log.error(errorMessage, e);
            MetricsUtils.addFailureTagsWithException(tags, e);
            if (e instanceof ResourceSelectionException) {
                throw e;
            }
            throw new ResourceSelectionException(e);
        }
        finally {
            this.registry.timer(SELECT_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - selectStart, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public Collection<AgentLauncher> getAgentLaunchers() {
        return this.agentLaunchers;
    }
}

