/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.scripts;

import com.netflix.genie.common.internal.util.PropertiesMapCache;
import com.netflix.genie.web.properties.AgentLauncherSelectorScriptProperties;
import com.netflix.genie.web.properties.ClusterSelectorScriptProperties;
import com.netflix.genie.web.properties.CommandSelectorManagedScriptProperties;
import com.netflix.genie.web.properties.ScriptManagerProperties;
import com.netflix.genie.web.scripts.AgentLauncherSelectorManagedScript;
import com.netflix.genie.web.scripts.ClusterSelectorManagedScript;
import com.netflix.genie.web.scripts.CommandSelectorManagedScript;
import com.netflix.genie.web.scripts.ManagedScript;
import com.netflix.genie.web.scripts.ScriptManager;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.concurrent.Executors;
import javax.script.ScriptEngineManager;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.TaskScheduler;

@Configuration
@EnableConfigurationProperties(value={AgentLauncherSelectorScriptProperties.class, ClusterSelectorScriptProperties.class, CommandSelectorManagedScriptProperties.class, ScriptManagerProperties.class})
public class ScriptsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ScriptManager.class})
    ScriptManager scriptManager(ScriptManagerProperties scriptManagerProperties, @Qualifier(value="genieTaskScheduler") TaskScheduler taskScheduler, ResourceLoader resourceLoader, MeterRegistry meterRegistry) {
        return new ScriptManager(scriptManagerProperties, taskScheduler, Executors.newCachedThreadPool(), new ScriptEngineManager(), resourceLoader, meterRegistry);
    }

    @Bean
    public ManagedScriptPreLoader managedScriptPreLoader(List<ManagedScript> managedScripts) {
        return new ManagedScriptPreLoader(managedScripts);
    }

    @Bean
    @ConditionalOnMissingBean(value={ClusterSelectorManagedScript.class})
    @ConditionalOnProperty(value={"genie.scripts.cluster-selector.source"})
    ClusterSelectorManagedScript clusterSelectorScript(ScriptManager scriptManager, ClusterSelectorScriptProperties scriptProperties, PropertiesMapCache.Factory propertyMapCacheFactory, MeterRegistry meterRegistry) {
        return new ClusterSelectorManagedScript(scriptManager, scriptProperties, meterRegistry, propertyMapCacheFactory.get(scriptProperties.getPropertiesRefreshInterval(), "cluster-selector."));
    }

    @Bean
    @ConditionalOnMissingBean(value={CommandSelectorManagedScript.class})
    @ConditionalOnProperty(value={"genie.scripts.command-selector.source"})
    CommandSelectorManagedScript commandSelectormanagedScript(ScriptManager scriptManager, CommandSelectorManagedScriptProperties scriptProperties, PropertiesMapCache.Factory propertyMapCacheFactory, MeterRegistry meterRegistry) {
        return new CommandSelectorManagedScript(scriptManager, scriptProperties, meterRegistry, propertyMapCacheFactory.get(scriptProperties.getPropertiesRefreshInterval(), "command-selector."));
    }

    @Bean
    @ConditionalOnMissingBean(value={AgentLauncherSelectorManagedScript.class})
    @ConditionalOnProperty(value={"genie.scripts.agent-launcher-selector.source"})
    AgentLauncherSelectorManagedScript agentLauncherSelectorManagedScript(ScriptManager scriptManager, AgentLauncherSelectorScriptProperties scriptProperties, PropertiesMapCache.Factory propertyMapCacheFactory, MeterRegistry meterRegistry) {
        return new AgentLauncherSelectorManagedScript(scriptManager, scriptProperties, meterRegistry, propertyMapCacheFactory.get(scriptProperties.getPropertiesRefreshInterval(), "agent-launcher-selector."));
    }

    static final class ManagedScriptPreLoader
    implements SmartInitializingSingleton {
        private List<ManagedScript> managedScripts;

        private ManagedScriptPreLoader(List<ManagedScript> managedScripts) {
            this.managedScripts = managedScripts;
        }

        public void afterSingletonsInstantiated() {
            this.managedScripts.forEach(ManagedScript::warmUp);
        }
    }
}

