/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.controllers;

import com.google.common.collect.Sets;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.exceptions.GenieUserLimitExceededException;
import com.netflix.genie.common.internal.exceptions.checked.GenieCheckedException;
import com.netflix.genie.common.internal.exceptions.checked.GenieJobResolutionException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieApplicationNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieClusterNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieCommandNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieIdAlreadyExistsException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobSpecificationNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieRuntimeException;
import com.netflix.genie.web.exceptions.checked.AttachmentTooLargeException;
import com.netflix.genie.web.exceptions.checked.IdAlreadyExistsException;
import com.netflix.genie.web.exceptions.checked.JobNotFoundException;
import com.netflix.genie.web.exceptions.checked.NotFoundException;
import com.netflix.genie.web.exceptions.checked.PreconditionFailedException;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.HashSet;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class GenieExceptionMapper {
    private static final Logger log = LoggerFactory.getLogger(GenieExceptionMapper.class);
    static final String CONTROLLER_EXCEPTION_COUNTER_NAME = "genie.web.controllers.exception";
    private static final String USER_NAME_TAG_KEY = "user";
    private static final String LIMIT_TAG_KEY = "limit";
    private final MeterRegistry registry;

    @Autowired
    public GenieExceptionMapper(MeterRegistry registry) {
        this.registry = registry;
    }

    @ExceptionHandler(value={GenieException.class})
    public ResponseEntity<GenieException> handleGenieException(GenieException e) {
        this.countExceptionAndLog((Exception)((Object)e));
        HttpStatus status = HttpStatus.resolve((int)e.getErrorCode());
        if (status == null) {
            status = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return new ResponseEntity((Object)e, status);
    }

    @ExceptionHandler(value={GenieRuntimeException.class})
    public ResponseEntity<GenieRuntimeException> handleGenieRuntimeException(GenieRuntimeException e) {
        this.countExceptionAndLog((Exception)e);
        if (e instanceof GenieApplicationNotFoundException || e instanceof GenieCommandNotFoundException || e instanceof GenieClusterNotFoundException || e instanceof GenieJobNotFoundException || e instanceof GenieJobSpecificationNotFoundException) {
            return new ResponseEntity((Object)e, HttpStatus.NOT_FOUND);
        }
        if (e instanceof GenieIdAlreadyExistsException) {
            return new ResponseEntity((Object)e, HttpStatus.CONFLICT);
        }
        return new ResponseEntity((Object)e, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={GenieCheckedException.class})
    public ResponseEntity<GenieCheckedException> handleGenieCheckedException(GenieCheckedException e) {
        this.countExceptionAndLog((Exception)((Object)e));
        if (e instanceof GenieJobResolutionException) {
            return new ResponseEntity((Object)e, HttpStatus.PRECONDITION_FAILED);
        }
        if (e instanceof IdAlreadyExistsException) {
            return new ResponseEntity((Object)e, HttpStatus.CONFLICT);
        }
        if (e instanceof JobNotFoundException | e instanceof NotFoundException) {
            return new ResponseEntity((Object)e, HttpStatus.NOT_FOUND);
        }
        if (e instanceof PreconditionFailedException) {
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
        if (e instanceof AttachmentTooLargeException) {
            return new ResponseEntity((Object)e, HttpStatus.PAYLOAD_TOO_LARGE);
        }
        return new ResponseEntity((Object)e, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<GeniePreconditionException> handleConstraintViolation(ConstraintViolationException cve) {
        this.countExceptionAndLog((Exception)cve);
        return new ResponseEntity((Object)new GeniePreconditionException(cve.getMessage(), (Throwable)cve), HttpStatus.PRECONDITION_FAILED);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<GeniePreconditionException> handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        this.countExceptionAndLog((Exception)e);
        return new ResponseEntity((Object)new GeniePreconditionException(e.getMessage(), (Throwable)e), HttpStatus.PRECONDITION_FAILED);
    }

    private void countExceptionAndLog(Exception e) {
        HashSet tags = Sets.newHashSet((Iterable)Tags.of((String)"exceptionClass", (String)e.getClass().getCanonicalName()));
        if (e instanceof GenieUserLimitExceededException) {
            GenieUserLimitExceededException userLimitExceededException = (GenieUserLimitExceededException)e;
            tags.add(Tag.of((String)USER_NAME_TAG_KEY, (String)userLimitExceededException.getUser()));
            tags.add(Tag.of((String)LIMIT_TAG_KEY, (String)userLimitExceededException.getExceededLimitName()));
        }
        this.registry.counter(CONTROLLER_EXCEPTION_COUNTER_NAME, (Iterable)tags).increment();
        log.error("{}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getLocalizedMessage());
        log.debug("{}: {}", new Object[]{e.getClass().getCanonicalName(), e.getMessage(), e});
    }
}

