/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import java.time.Duration;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.time.DurationMin;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.agent.connection-tracking")
@Validated
public class AgentConnectionTrackingServiceProperties {
    static final String PREFIX = "genie.agent.connection-tracking";
    @NotNull
    @DurationMin(seconds=1L)
    private @NotNull @DurationMin(seconds=1L) Duration cleanupInterval = Duration.ofSeconds(2L);
    @NotNull
    @DurationMin(seconds=1L)
    private @NotNull @DurationMin(seconds=1L) Duration connectionExpirationPeriod = Duration.ofSeconds(10L);

    public Duration getCleanupInterval() {
        return this.cleanupInterval;
    }

    public Duration getConnectionExpirationPeriod() {
        return this.connectionExpirationPeriod;
    }

    public void setCleanupInterval(Duration cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    public void setConnectionExpirationPeriod(Duration connectionExpirationPeriod) {
        this.connectionExpirationPeriod = connectionExpirationPeriod;
    }
}

