/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.services;

import com.netflix.genie.common.internal.aws.s3.S3ClientFactory;
import com.netflix.genie.common.internal.tracing.brave.BraveTracingComponents;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.agent.services.AgentFileStreamService;
import com.netflix.genie.web.agent.services.AgentRoutingService;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.properties.AttachmentServiceProperties;
import com.netflix.genie.web.properties.JobsActiveLimitProperties;
import com.netflix.genie.web.properties.JobsForwardingProperties;
import com.netflix.genie.web.properties.JobsLocationsProperties;
import com.netflix.genie.web.properties.JobsMemoryProperties;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.properties.JobsUsersProperties;
import com.netflix.genie.web.selectors.AgentLauncherSelector;
import com.netflix.genie.web.selectors.ClusterSelector;
import com.netflix.genie.web.selectors.CommandSelector;
import com.netflix.genie.web.services.ArchivedJobService;
import com.netflix.genie.web.services.AttachmentService;
import com.netflix.genie.web.services.JobDirectoryServerService;
import com.netflix.genie.web.services.JobLaunchService;
import com.netflix.genie.web.services.JobResolverService;
import com.netflix.genie.web.services.RequestForwardingService;
import com.netflix.genie.web.services.impl.ArchivedJobServiceImpl;
import com.netflix.genie.web.services.impl.JobDirectoryServerServiceImpl;
import com.netflix.genie.web.services.impl.JobLaunchServiceImpl;
import com.netflix.genie.web.services.impl.JobResolverServiceImpl;
import com.netflix.genie.web.services.impl.LocalFileSystemAttachmentServiceImpl;
import com.netflix.genie.web.services.impl.RequestForwardingServiceImpl;
import com.netflix.genie.web.services.impl.S3AttachmentServiceImpl;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={JobsForwardingProperties.class, JobsLocationsProperties.class, JobsMemoryProperties.class, JobsUsersProperties.class, JobsActiveLimitProperties.class, AttachmentServiceProperties.class})
public class ServicesAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ServicesAutoConfiguration.class);

    @Bean
    public JobsProperties jobsProperties(JobsForwardingProperties forwarding, JobsLocationsProperties locations, JobsMemoryProperties memory, JobsUsersProperties users, JobsActiveLimitProperties activeLimit) {
        return new JobsProperties(forwarding, locations, memory, users, activeLimit);
    }

    @Bean
    @ConditionalOnMissingBean(value={AttachmentService.class})
    public AttachmentService attachmentService(S3ClientFactory s3ClientFactory, AttachmentServiceProperties attachmentServiceProperties, MeterRegistry meterRegistry) throws IOException {
        @NotNull URI location = attachmentServiceProperties.getLocationPrefix();
        String scheme = location.getScheme();
        if ("s3".equals(scheme)) {
            return new S3AttachmentServiceImpl(s3ClientFactory, attachmentServiceProperties, meterRegistry);
        }
        if ("file".equals(scheme)) {
            return new LocalFileSystemAttachmentServiceImpl(attachmentServiceProperties);
        }
        throw new IllegalStateException("Unknown attachment service implementation to use for location: " + location);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobResolverService.class})
    public JobResolverServiceImpl jobResolverService(DataServices dataServices, @NotEmpty List<ClusterSelector> clusterSelectors, CommandSelector commandSelector, MeterRegistry registry, JobsProperties jobsProperties, Environment environment) {
        return new JobResolverServiceImpl(dataServices, clusterSelectors, commandSelector, registry, jobsProperties, environment);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobDirectoryServerService.class})
    public JobDirectoryServerServiceImpl jobDirectoryServerService(ResourceLoader resourceLoader, DataServices dataServices, AgentFileStreamService agentFileStreamService, ArchivedJobService archivedJobService, MeterRegistry meterRegistry, AgentRoutingService agentRoutingService) {
        return new JobDirectoryServerServiceImpl(resourceLoader, dataServices, agentFileStreamService, archivedJobService, meterRegistry, agentRoutingService);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobLaunchService.class})
    public JobLaunchServiceImpl jobLaunchService(DataServices dataServices, JobResolverService jobResolverService, AgentLauncherSelector agentLauncherSelector, BraveTracingComponents tracingComponents, MeterRegistry registry) {
        return new JobLaunchServiceImpl(dataServices, jobResolverService, agentLauncherSelector, tracingComponents, registry);
    }

    @Bean
    @ConditionalOnMissingBean(value={ArchivedJobService.class})
    public ArchivedJobServiceImpl archivedJobService(DataServices dataServices, ResourceLoader resourceLoader, MeterRegistry meterRegistry) {
        return new ArchivedJobServiceImpl(dataServices, resourceLoader, meterRegistry);
    }

    @Bean
    @ConditionalOnMissingBean(value={RequestForwardingService.class})
    public RequestForwardingServiceImpl requestForwardingService(@Qualifier(value="genieRestTemplate") RestTemplate genieRestTemplate, GenieHostInfo hostInfo, JobsForwardingProperties jobsForwardingProperties) {
        return new RequestForwardingServiceImpl(genieRestTemplate, hostInfo, jobsForwardingProperties);
    }
}

