/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice.servlet;

import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import com.google.inject.servlet.GuiceServletContextListener;
import com.netflix.governator.LifecycleShutdownSignal;
import javax.servlet.ServletContextEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GovernatorServletContextListener
extends GuiceServletContextListener {
    protected static final Logger LOG = LoggerFactory.getLogger(GovernatorServletContextListener.class);
    static final String INJECTOR_NAME = Injector.class.getName();
    private Injector injector;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        super.contextInitialized(servletContextEvent);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        super.contextDestroyed(servletContextEvent);
        if (this.injector != null) {
            ((LifecycleShutdownSignal)this.injector.getInstance(LifecycleShutdownSignal.class)).signal();
        }
    }

    protected final Injector getInjector() {
        try {
            return this.createInjector();
        }
        catch (Exception e) {
            LOG.error("Failed to created injector", (Throwable)e);
            throw new ProvisionException("Failed to create injector", (Throwable)e);
        }
    }

    protected abstract Injector createInjector() throws Exception;
}

