/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.ssl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.netflix.client.ssl.AbstractSslContextFactory;
import com.netflix.client.ssl.ClientSslSocketFactoryException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLSslContextFactory
extends AbstractSslContextFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLSslContextFactory.class);
    private final URL keyStoreUrl;
    private final URL trustStoreUrl;

    public URLSslContextFactory(URL trustStoreUrl, String trustStorePassword, URL keyStoreUrl, String keyStorePassword) throws ClientSslSocketFactoryException {
        super(URLSslContextFactory.createKeyStore(trustStoreUrl, trustStorePassword), trustStorePassword, URLSslContextFactory.createKeyStore(keyStoreUrl, keyStorePassword), keyStorePassword);
        this.keyStoreUrl = keyStoreUrl;
        this.trustStoreUrl = trustStoreUrl;
        LOGGER.info("Loaded keyStore from: {}", (Object)keyStoreUrl);
        LOGGER.info("loaded trustStore from: {}", (Object)trustStoreUrl);
    }

    private static KeyStore createKeyStore(URL storeFile, String password) throws ClientSslSocketFactoryException {
        if (storeFile == null) {
            return null;
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)password), (Object)"Null keystore should have empty password, defined keystore must have password");
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("jks");
            InputStream is = storeFile.openStream();
            try {
                keyStore.load(is, password.toCharArray());
            }
            catch (NoSuchAlgorithmException e) {
                throw new ClientSslSocketFactoryException(String.format("Failed to create a keystore that supports algorithm %s: %s", "SSL", e.getMessage()), e);
            }
            catch (CertificateException e) {
                throw new ClientSslSocketFactoryException(String.format("Failed to create keystore with algorithm %s due to certificate exception: %s", "SSL", e.getMessage()), e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
        catch (KeyStoreException e) {
            throw new ClientSslSocketFactoryException(String.format("KeyStore exception creating keystore: %s", e.getMessage()), e);
        }
        catch (IOException e) {
            throw new ClientSslSocketFactoryException(String.format("IO exception creating keystore: %s", e.getMessage()), e);
        }
        return keyStore;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ClientSslSocketFactory [trustStoreUrl=").append(this.trustStoreUrl);
        if (this.trustStoreUrl != null) {
            builder.append(", trustStorePassword=");
            builder.append(Strings.repeat((String)"*", (int)this.getTrustStorePasswordLength()));
        }
        builder.append(", keyStoreUrl=").append(this.keyStoreUrl);
        if (this.keyStoreUrl != null) {
            builder.append(", keystorePassword = ");
            builder.append(Strings.repeat((String)"*", (int)this.getKeyStorePasswordLength()));
        }
        builder.append(']');
        return builder.toString();
    }
}

