/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.jvm;

import com.netflix.spectator.api.AbstractMeter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import java.lang.management.BufferPoolMXBean;
import java.util.ArrayList;

class BufferPoolMeter
extends AbstractMeter<BufferPoolMXBean> {
    private final Id countId;
    private final Id memoryUsedId;

    private static Id meterId(Registry registry, String id) {
        return registry.createId("jvm.buffer").withTag("id", id);
    }

    private static Id bufferCountId(Registry registry, String id) {
        return registry.createId("jvm.buffer.count").withTag("id", id);
    }

    private static Id bufferMemoryUsedId(Registry registry, String id) {
        return registry.createId("jvm.buffer.memoryUsed").withTag("id", id);
    }

    BufferPoolMeter(Registry registry, BufferPoolMXBean mbean) {
        super(registry.clock(), BufferPoolMeter.meterId(registry, mbean.getName()), (Object)mbean);
        this.countId = BufferPoolMeter.bufferCountId(registry, mbean.getName());
        this.memoryUsedId = BufferPoolMeter.bufferMemoryUsedId(registry, mbean.getName());
    }

    public Iterable<Measurement> measure() {
        long timestamp = this.clock.wallTime();
        BufferPoolMXBean mbean = (BufferPoolMXBean)this.ref.get();
        ArrayList<Measurement> ms = new ArrayList<Measurement>();
        if (mbean != null) {
            ms.add(new Measurement(this.countId, timestamp, (double)mbean.getCount()));
            ms.add(new Measurement(this.memoryUsedId, timestamp, (double)mbean.getMemoryUsed()));
        }
        return ms;
    }
}

