/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.jvm;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.jvm.JmxConfig;
import com.netflix.spectator.jvm.JmxData;
import com.netflix.spectator.jvm.JmxMeasurementConfig;
import com.typesafe.config.Config;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxPoller {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxPoller.class);
    private final Registry registry;
    private List<JmxConfig> configs = Collections.emptyList();

    public JmxPoller(Registry registry) {
        this.registry = registry;
    }

    public void updateConfigs(List<? extends Config> configs) {
        this.configs = configs.stream().map(JmxConfig::from).collect(Collectors.toList());
    }

    public void poll() {
        for (JmxConfig config : this.configs) {
            try {
                for (JmxData data : JmxData.query(config.getQuery())) {
                    for (JmxMeasurementConfig cfg : config.getMeasurements()) {
                        cfg.measure(this.registry, data);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("failed to query jmx data: {}", (Object)config.getQuery().getCanonicalName(), (Object)e);
            }
        }
    }
}

