/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.AnalysisPolicy;
import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.flow.context.free.DefaultAnalysisContextPolicy;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.typestore.ArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.FieldTypeStore;
import com.oracle.graal.pointsto.typestore.UnifiedArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.UnifiedFieldTypeStore;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.options.OptionValues;

public class DefaultAnalysisPolicy
extends AnalysisPolicy {
    private DefaultAnalysisContextPolicy contextPolicy = new DefaultAnalysisContextPolicy();

    public DefaultAnalysisPolicy(OptionValues options) {
        super(options);
    }

    public DefaultAnalysisContextPolicy contextPolicy() {
        return this.contextPolicy;
    }

    @Override
    public boolean needsConstantCache() {
        return false;
    }

    @Override
    public boolean isSummaryObject(AnalysisObject object) {
        return object.isContextInsensitiveObject();
    }

    @Override
    public boolean isMergingEnabled() {
        return false;
    }

    @Override
    public void noteMerge(BigBang bb, TypeState t) {
    }

    @Override
    public void noteMerge(BigBang bb, AnalysisObject ... a) {
    }

    @Override
    public boolean isContextSensitiveAllocation(BigBang bb, AnalysisType type, AnalysisContext allocationContext) {
        return false;
    }

    @Override
    public AnalysisObject createHeapObject(BigBang bb, AnalysisType type, BytecodeLocation allocationSite, AnalysisContext allocationContext) {
        return type.getContextInsensitiveAnalysisObject();
    }

    @Override
    public AnalysisObject createConstantObject(BigBang bb, JavaConstant constant, AnalysisType exactType) {
        return exactType.getContextInsensitiveAnalysisObject();
    }

    @Override
    public BytecodeLocation createAllocationSite(BigBang bb, int bci, AnalysisMethod method) {
        return BytecodeLocation.create(bci, method);
    }

    @Override
    public FieldTypeStore createFieldTypeStore(AnalysisObject object, AnalysisField field, AnalysisUniverse universe) {
        return new UnifiedFieldTypeStore(field, object);
    }

    @Override
    public ArrayElementsTypeStore createArrayElementsTypeStore(AnalysisObject object, AnalysisUniverse universe) {
        if (object.type().isArray()) {
            return new UnifiedArrayElementsTypeStore(object);
        }
        return null;
    }

    @Override
    public AbstractVirtualInvokeTypeFlow createVirtualInvokeTypeFlow(Invoke invoke, MethodCallTargetNode target, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
        return new DefaultVirtualInvokeTypeFlow(invoke, target, actualParameters, actualReturn, location);
    }

    private static class DefaultVirtualInvokeTypeFlow
    extends AbstractVirtualInvokeTypeFlow {
        private TypeState seenReceiverTypes = TypeState.forEmpty();

        protected DefaultVirtualInvokeTypeFlow(Invoke invoke, MethodCallTargetNode target, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
            super(invoke, target, actualParameters, actualReturn, location);
        }

        protected DefaultVirtualInvokeTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, DefaultVirtualInvokeTypeFlow original) {
            super(bb, methodFlows, original);
        }

        @Override
        public TypeFlow<MethodCallTargetNode> copy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new DefaultVirtualInvokeTypeFlow(bb, methodFlows, this);
        }

        @Override
        public void onObservedUpdate(BigBang bb) {
            assert (this.isClone());
            TypeState receiverState = this.getReceiver().getState();
            if (receiverState.isUnknown()) {
                bb.reportIllegalUnknownUse(this.graphRef.getMethod(), (Node)this.source, "Illegal: Invoke on UnknownTypeState objects. Invoke: " + this);
                return;
            }
            for (AnalysisType type : receiverState.types()) {
                AnalysisMethod method;
                if (this.seenReceiverTypes.containsType(type) || (method = type.resolveConcreteMethod(this.getTargetMethod(), ((MethodCallTargetNode)this.getSource()).invoke().getContextType())) == null || Modifier.isAbstract(method.getModifiers())) continue;
                assert (!Modifier.isAbstract(method.getModifiers()));
                MethodTypeFlow callee = method.getTypeFlow();
                MethodFlowsGraph calleeFlows = callee.addContext(bb, bb.contextPolicy().emptyContext(), this);
                assert (callee.getContexts()[0] == bb.contextPolicy().emptyContext());
                if (this.addCallee(callee.getMethod())) {
                    this.linkCallee(bb, false, calleeFlows);
                }
                this.updateReceiver(bb, calleeFlows, TypeState.forExactType(bb, type, false));
            }
            this.seenReceiverTypes = receiverState;
        }

        @Override
        public Collection<MethodFlowsGraph> getCalleesFlows(BigBang bb) {
            ArrayList<MethodFlowsGraph> methodFlowsGraphs = new ArrayList<MethodFlowsGraph>(this.callees.size());
            for (AnalysisMethod method : this.callees.getElements()) {
                methodFlowsGraphs.add(method.getTypeFlow().getFlows(bb.contextPolicy().emptyContext()));
            }
            return methodFlowsGraphs;
        }
    }
}

