/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.typestate.TypeState;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.java.LoadFieldNode;

public abstract class LoadFieldTypeFlow
extends TypeFlow<LoadFieldNode> {
    protected final AnalysisField field;

    public LoadFieldTypeFlow(LoadFieldNode node) {
        super(node, null);
        this.field = (AnalysisField)node.field();
    }

    public LoadFieldTypeFlow(MethodFlowsGraph methodFlows, LoadFieldTypeFlow original) {
        super(original, methodFlows);
        this.field = original.field;
    }

    public AnalysisField field() {
        return this.field;
    }

    public static class LoadInstanceFieldTypeFlow
    extends LoadFieldTypeFlow {
        private final TypeFlow<?> objectFlow;

        LoadInstanceFieldTypeFlow(LoadFieldNode node, TypeFlow<?> objectFlow) {
            super(node);
            this.objectFlow = objectFlow;
        }

        LoadInstanceFieldTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, LoadInstanceFieldTypeFlow original) {
            super(methodFlows, original);
            this.objectFlow = methodFlows.lookupCloneOf(bb, original.objectFlow);
        }

        public LoadFieldTypeFlow copy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new LoadInstanceFieldTypeFlow(bb, methodFlows, this);
        }

        @Override
        public TypeFlow<?> receiver() {
            return this.objectFlow;
        }

        public TypeState getObjectState() {
            return this.objectFlow.getState();
        }

        @Override
        public boolean addState(BigBang bb, TypeState add) {
            assert (this.isClone());
            return super.addState(bb, add);
        }

        @Override
        public void onObservedUpdate(BigBang bb) {
            assert (this.isClone());
            TypeState objectState = this.objectFlow.getState();
            if (objectState.isUnknown()) {
                bb.reportIllegalUnknownUse(this.graphRef.getMethod(), (Node)this.source, "Illegal: Field loading from UnknownTypeState objects. Field: " + this.field);
                return;
            }
            for (AnalysisObject object : objectState.objects()) {
                FieldTypeFlow fieldFlow = object.getInstanceFieldFlow(bb, this.field, false);
                fieldFlow.addUse(bb, this);
            }
        }

        @Override
        public String toString() {
            return "LoadInstanceFieldTypeFlow<" + this.getState() + ">";
        }
    }

    public static class LoadStaticFieldTypeFlow
    extends LoadFieldTypeFlow {
        private final FieldTypeFlow fieldFlow;

        LoadStaticFieldTypeFlow(LoadFieldNode node, FieldTypeFlow fieldFlow) {
            super(node);
            this.fieldFlow = fieldFlow;
        }

        LoadStaticFieldTypeFlow(MethodFlowsGraph methodFlows, LoadStaticFieldTypeFlow original) {
            super(methodFlows, original);
            this.fieldFlow = original.fieldFlow;
        }

        @Override
        public TypeFlow<LoadFieldNode> copy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new LoadStaticFieldTypeFlow(methodFlows, this);
        }

        @Override
        public void initClone(BigBang bb) {
            this.fieldFlow.addUse(bb, this);
        }

        @Override
        public boolean addState(BigBang bb, TypeState add) {
            assert (this.isClone());
            return super.addState(bb, add);
        }

        @Override
        public String toString() {
            return "LoadStaticFieldTypeFlow<" + this.getState() + ">";
        }
    }
}

