/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import java.io.PrintWriter;
import java.io.StringWriter;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class AnalysisError
extends Error {
    private static final long serialVersionUID = -4489048906003856416L;

    AnalysisError() {
    }

    AnalysisError(String msg) {
        super(msg);
    }

    AnalysisError(Throwable ex) {
        super(ex);
    }

    AnalysisError(String msg, Throwable cause) {
        super(msg, cause);
    }

    public static TypeNotFoundError typeNotFound(ResolvedJavaType type) {
        throw new TypeNotFoundError(type);
    }

    public static ParsingError parsingError(AnalysisMethod method, Throwable original) {
        throw new ParsingError(method, original);
    }

    public static RuntimeException shouldNotReachHere() {
        throw new AnalysisError("should not reach here");
    }

    public static RuntimeException shouldNotReachHere(String msg) {
        throw new AnalysisError("should not reach here: " + msg);
    }

    public static RuntimeException shouldNotReachHere(Throwable cause) {
        throw new AnalysisError(cause);
    }

    public static class ParsingError
    extends AnalysisError {
        private static final long serialVersionUID = -7167507945764369928L;
        private final AnalysisMethod method;

        ParsingError(AnalysisMethod method, Throwable cause) {
            super(ParsingError.message(method, cause));
            this.method = method;
        }

        public AnalysisMethod getMethod() {
            return this.method;
        }

        private static String message(AnalysisMethod method, Throwable original) {
            String msg = String.format("Error encountered while parsing %s %n", method.format("%H.%n(%P)"));
            msg = msg + String.format("Parsing context:", new Object[0]);
            if (method.getTypeFlow().getParsingContext().length > 0) {
                for (StackTraceElement e : method.getTypeFlow().getParsingContext()) {
                    msg = msg + String.format("%n\tparsing %s", e);
                }
                msg = msg + String.format("%n", new Object[0]);
            } else {
                msg = msg + String.format(" <no parsing context available> %n", new Object[0]);
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            original.printStackTrace(pw);
            msg = msg + String.format("Original error: %s", sw.toString());
            return msg;
        }
    }

    public static class TypeNotFoundError
    extends AnalysisError {
        private static final long serialVersionUID = -7167507945764369928L;
        private final ResolvedJavaType type;

        TypeNotFoundError(ResolvedJavaType type) {
            super("Type not found during analysis: " + type);
            this.type = type;
        }

        public ResolvedJavaType getType() {
            return this.type;
        }
    }
}

