/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.type.OBuffer;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OFixDeleteRecordTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ODeleteRecordTask
extends OAbstractRecordReplicatedTask {
    private static final long serialVersionUID = 1L;

    public ODeleteRecordTask() {
    }

    public ODeleteRecordTask(ORecordId iRid, ORecordVersion iVersion) {
        super(iRid, iVersion);
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        OBuffer buffer;
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.IN, "delete record %s/%s v.%s", database.getName(), this.rid.toString(), this.version.toString());
        ORecordInternal record = database.load((ORID)this.rid);
        if (record != null) {
            buffer = new OBuffer(record.toStream());
            record.delete();
        } else {
            buffer = new OBuffer();
        }
        return buffer;
    }

    @Override
    public OAbstractRemoteTask.QUORUM_TYPE getQuorumType() {
        return OAbstractRemoteTask.QUORUM_TYPE.WRITE;
    }

    @Override
    public OFixDeleteRecordTask getFixTask(ODistributedRequest iRequest, ODistributedResponse iBadResponse, ODistributedResponse iGoodResponse) {
        return new OFixDeleteRecordTask(this.rid, this.version);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.rid.toString());
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().writeTo((DataOutput)out, this.version);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rid = new ORecordId(in.readUTF());
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().readFrom((DataInput)in, this.version);
    }

    @Override
    public String getName() {
        return "record_delete";
    }
}

