/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OFixUpdateRecordTask
extends OAbstractRemoteTask {
    private static final long serialVersionUID = 1L;
    private ORecordId rid;
    private byte[] content;
    private ORecordVersion version;

    public OFixUpdateRecordTask() {
    }

    public OFixUpdateRecordTask(ORecordId iRid, byte[] iContent, ORecordVersion iVersion) {
        this.rid = iRid;
        this.content = iContent;
        this.version = iVersion;
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "fixing update record %s/%s v.%s", database.getName(), this.rid.toString(), this.version.toString());
        ORecordInternal record = (ORecordInternal)this.rid.getRecord();
        if (record == null) {
            return Boolean.FALSE;
        }
        ORecordInternal newRecord = Orient.instance().getRecordFactoryManager().newInstance(record.getRecordType());
        newRecord.fill((ORID)this.rid, this.version, this.content, true);
        ((ODocument)record).merge((ODocument)newRecord, false, false);
        database.save(record);
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "+-> fixed update record %s/%s v.%s", database.getName(), record.getIdentity().toString(), record.getRecordVersion().toString());
        return Boolean.TRUE;
    }

    @Override
    public OAbstractRemoteTask.QUORUM_TYPE getQuorumType() {
        return OAbstractRemoteTask.QUORUM_TYPE.NONE;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.rid.toString());
        out.writeInt(this.content.length);
        out.write(this.content);
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().writeTo((DataOutput)out, this.version);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rid = new ORecordId(in.readUTF());
        int contentSize = in.readInt();
        this.content = new byte[contentSize];
        in.readFully(this.content);
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().readFrom((DataInput)in, this.version);
    }

    @Override
    public String getName() {
        return "fix_record_update";
    }
}

