/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.server.network.protocol.binary.OAbstractCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class OAsyncCommandResultListener
extends OAbstractCommandResultListener {
    private final ONetworkProtocolBinary protocol;
    private final AtomicBoolean empty = new AtomicBoolean(true);
    private final int txId;

    public OAsyncCommandResultListener(ONetworkProtocolBinary iNetworkProtocolBinary, int txId) {
        this.protocol = iNetworkProtocolBinary;
        this.txId = txId;
    }

    public boolean result(Object iRecord) {
        if (this.empty.compareAndSet(true, false)) {
            try {
                this.protocol.sendOk(this.txId);
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        try {
            this.protocol.channel.writeByte((byte)1);
            this.protocol.writeIdentifiable((OIdentifiable)((ORecordInternal)((OIdentifiable)iRecord).getRecord()));
            this.fetchRecord(iRecord);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.empty.get();
    }
}

