/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.storage.impl.local.ODataHoleInfo;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;

public class OServerCommandGetStorageAllocation
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|allocation/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 2, "Syntax error: allocation/<database>");
        iRequest.data.commandInfo = "Storage allocation";
        iRequest.data.commandDetail = urlParts[1];
        ODatabaseDocumentTx db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            if (!(db.getStorage() instanceof OStorageLocal)) {
                throw new IllegalArgumentException("Cannot get allocation information for database '" + iRequest.databaseName + "' because it is not a disk-based database");
            }
            List holes = ((OStorageLocal)db.getStorage()).getHolesList();
            Collections.sort(holes);
            StringWriter buffer = new StringWriter();
            OJSONWriter json = new OJSONWriter((Writer)buffer);
            ODataLocal dataSegment = ((OStorageLocal)db.getStorage()).getDataSegmentById(0);
            long dbSize = dataSegment.getFilledUpTo();
            json.beginObject();
            json.writeAttribute(1, true, "size", (Object)dbSize);
            long current = 0L;
            long holesSize = 0L;
            json.beginCollection(1, true, "segments");
            for (ODataHoleInfo h : holes) {
                if (h.dataOffset == -1L) continue;
                if (current < h.dataOffset) {
                    json.beginObject(2, true, null);
                    json.writeAttribute(3, false, "type", (Object)"d");
                    json.writeAttribute(3, false, "offset", (Object)current);
                    json.writeAttribute(3, false, "size", (Object)(h.dataOffset - current));
                    json.endObject(2, false);
                }
                json.beginObject(2, true, null);
                json.writeAttribute(3, false, "type", (Object)"h");
                json.writeAttribute(3, false, "offset", (Object)h.dataOffset);
                json.writeAttribute(3, false, "size", (Object)h.size);
                json.endObject(2, false);
                holesSize += (long)h.size;
                current = h.dataOffset + (long)h.size;
            }
            if (dbSize > current) {
                json.beginObject(2, true, null);
                json.writeAttribute(3, false, "type", (Object)"d");
                json.writeAttribute(3, false, "offset", (Object)current);
                json.writeAttribute(3, false, "size", (Object)(dbSize - current));
                json.endObject(2, false);
            }
            json.endCollection(1, true);
            json.writeAttribute(1, true, "dataSize", (Object)(dbSize - holesSize));
            json.writeAttribute(1, true, "dataSizePercent", (Object)((dbSize - holesSize) * 100L / dbSize));
            json.writeAttribute(1, true, "holesSize", (Object)holesSize);
            json.writeAttribute(1, true, "holesSizePercent", (Object)(100L - (dbSize - holesSize) * 100L / dbSize));
            json.endObject();
            json.flush();
            iResponse.send(200, "OK", "application/json", buffer.toString(), null);
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

