/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;
import java.util.Collection;
import java.util.Map;

public class OServerCommandPostBatch
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"POST|batch/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        this.checkSyntax(iRequest.url, 2, "Syntax error: batch/<database>");
        iRequest.data.commandInfo = "Execute multiple requests in one shot";
        ODatabaseDocumentTx db = null;
        ODocument batch = null;
        int executed = 0;
        try {
            Collection operations;
            db = this.getProfiledDatabaseInstance(iRequest);
            batch = (ODocument)new ODocument().fromJSON(iRequest.content);
            Boolean tx = (Boolean)batch.field("transaction");
            if (tx == null) {
                tx = false;
            }
            if ((operations = (Collection)batch.field("operations")) == null || operations.isEmpty()) {
                throw new IllegalArgumentException("Input JSON has no operations to execute");
            }
            if (tx.booleanValue()) {
                db.begin();
            }
            for (Map operation : operations) {
                String language;
                ODocument doc;
                String type = (String)operation.get("type");
                if (type.equals("c")) {
                    doc = this.getRecord(operation);
                    doc.save();
                    ++executed;
                    continue;
                }
                if (type.equals("u")) {
                    doc = this.getRecord(operation);
                    doc.save();
                    ++executed;
                    continue;
                }
                if (type.equals("d")) {
                    doc = this.getRecord(operation);
                    db.delete(doc.getIdentity());
                    ++executed;
                    continue;
                }
                if (type.equals("cmd")) {
                    language = (String)operation.get("language");
                    String command = (String)operation.get("command");
                    OCommandRequestText cmd = (OCommandRequestText)OCommandManager.instance().getRequester(language);
                    cmd.setText(command);
                    db.command((OCommandRequest)cmd).execute(new Object[0]);
                    ++executed;
                    continue;
                }
                if (!type.equals("script")) continue;
                language = (String)operation.get("language");
                String script = (String)operation.get("script");
                db.command((OCommandRequest)new OCommandScript(language, script)).execute(new Object[0]);
                ++executed;
            }
            if (tx.booleanValue()) {
                db.commit();
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        iResponse.send(200, "OK", "text/plain", executed, null, true);
        return false;
    }

    public ODocument getRecord(Map<Object, Object> operation) {
        Object record = operation.get("record");
        ODocument doc = record instanceof Map ? new ODocument((Map)record) : (ODocument)record;
        return doc;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

