/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.multipart;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartContentInputStream;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartContentParser;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class OHttpMultipartFileToDiskContentParser
implements OHttpMultipartContentParser<InputStream> {
    protected boolean overwrite = false;
    protected String path;

    public OHttpMultipartFileToDiskContentParser(String iPath) {
        this.path = iPath;
        if (!this.path.endsWith("/")) {
            this.path = this.path + "/";
        }
        new File(this.path).mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream parse(OHttpRequest iRequest, Map<String, String> headers, OHttpMultipartContentInputStream in, ODatabaseRecord database) throws IOException {
        StringWriter buffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)buffer);
        json.beginObject();
        String fileName = headers.get("filename");
        int fileSize = 0;
        if (fileName.charAt(0) == '\"') {
            fileName = fileName.substring(1);
        }
        if (fileName.charAt(fileName.length() - 1) == '\"') {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        fileName = this.path + fileName;
        if (!this.overwrite && new File(fileName).exists()) {
            String fileExt = fileName.substring(fileName.lastIndexOf("."));
            String fileNoExt = fileName.substring(0, fileName.lastIndexOf("."));
            int i = 1;
            while (true) {
                if (!new File(fileNoExt + "_" + i + fileExt).exists()) {
                    fileName = fileNoExt + "_" + i + fileExt;
                    break;
                }
                ++i;
            }
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileName.toString()));
        try {
            int b;
            while ((b = in.read()) > -1) {
                ((OutputStream)out).write(b);
                ++fileSize;
            }
        }
        finally {
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
        json.writeAttribute(1, true, "name", (Object)fileName);
        json.writeAttribute(1, true, "type", (Object)headers.get("Content-Type"));
        json.writeAttribute(1, true, "size", (Object)fileSize);
        json.endObject();
        return new ByteArrayInputStream(buffer.toString().getBytes());
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public OHttpMultipartFileToDiskContentParser setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }
}

