/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.JsonSerializable;
import com.prowidesoftware.swift.io.ConversionService;
import com.prowidesoftware.swift.io.parser.SwiftParser;
import com.prowidesoftware.swift.io.writer.XMLWriterVisitor;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.MOR;
import com.prowidesoftware.swift.model.MessageIOType;
import com.prowidesoftware.swift.model.MtId;
import com.prowidesoftware.swift.model.SwiftBlock;
import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2Adapter;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import com.prowidesoftware.swift.model.SwiftBlock3;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftBlock5;
import com.prowidesoftware.swift.model.SwiftBlock5Field;
import com.prowidesoftware.swift.model.SwiftBlockUser;
import com.prowidesoftware.swift.model.SwiftMessageAdapter;
import com.prowidesoftware.swift.model.SwiftMessageUtils;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.UETRUtils;
import com.prowidesoftware.swift.model.UnparsedTextList;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field108;
import com.prowidesoftware.swift.model.field.Field111;
import com.prowidesoftware.swift.model.field.Field119;
import com.prowidesoftware.swift.model.field.Field121;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.model.mt.MTVariant;
import com.prowidesoftware.swift.model.mt.MtCategory;
import com.prowidesoftware.swift.model.mt.ServiceIdType;
import com.prowidesoftware.swift.model.mt.ServiceMessage21;
import com.prowidesoftware.swift.utils.IMessageVisitor;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class SwiftMessage
implements Serializable,
JsonSerializable {
    static final int JSON_VERSION = 2;
    private static final long serialVersionUID = 8094995269559985432L;
    private static final transient Logger log = Logger.getLogger(SwiftMessage.class.getName());
    private static final String INVALID_NAME_BLOCK = "Invalid name for User Defined Blocks (";
    private static final String MESSAGE_IS_NOT_A_FRAGMENT = "message is not a fragment";
    private SwiftBlock1 block1;
    private SwiftBlock2 block2;
    private SwiftBlock3 block3;
    private SwiftBlock4 block4;
    private SwiftBlock5 block5;
    private List<SwiftBlockUser> userBlocks;
    private UnparsedTextList unparsedTexts = null;

    public SwiftMessage() {
    }

    public SwiftMessage(boolean initBlocks) {
        if (initBlocks) {
            this.block1 = new SwiftBlock1();
            this.block2 = new SwiftBlock2Input();
            this.block3 = new SwiftBlock3();
            this.block4 = new SwiftBlock4();
            this.block5 = new SwiftBlock5();
            this.userBlocks = new ArrayList<SwiftBlockUser>();
        }
    }

    public SwiftMessage(boolean initBlocks, UnparsedTextList unparsedText) {
        this(initBlocks);
        this.unparsedTexts = unparsedText;
    }

    public SwiftMessage(UnparsedTextList unparsedText) {
        this();
        this.unparsedTexts = unparsedText;
    }

    public static SwiftMessage parse(String fin) throws IOException {
        return new SwiftParser(fin).message();
    }

    public static void visit(SwiftBlock3 block, IMessageVisitor visitor) {
        Objects.requireNonNull(block);
        Objects.requireNonNull(visitor);
        Iterator<Tag> it = block.tagIterator();
        while (it.hasNext()) {
            visitor.tag(block, it.next());
        }
    }

    public static void visit(SwiftBlock4 block, IMessageVisitor visitor) {
        Objects.requireNonNull(block);
        Objects.requireNonNull(visitor);
        Iterator<Tag> it = block.tagIterator();
        while (it.hasNext()) {
            Tag t = it.next();
            visitor.tag(block, t);
        }
    }

    public static void visit(SwiftBlock5 block, IMessageVisitor visitor) {
        Objects.requireNonNull(block);
        Objects.requireNonNull(visitor);
        Iterator<Tag> it = block.tagIterator();
        while (it.hasNext()) {
            Tag t = it.next();
            visitor.tag(block, t);
        }
    }

    public static void visit(SwiftBlockUser block, IMessageVisitor visitor) {
        Objects.requireNonNull(block);
        Objects.requireNonNull(visitor);
        Iterator<Tag> it = block.tagIterator();
        while (it.hasNext()) {
            Tag t = it.next();
            visitor.tag(block, t);
        }
    }

    public static SwiftMessage fromJson(String json) {
        Gson gson = new GsonBuilder().registerTypeAdapter(SwiftMessage.class, (Object)new SwiftMessageAdapter()).registerTypeAdapter(SwiftBlock2.class, (Object)new SwiftBlock2Adapter()).create();
        return (SwiftMessage)gson.fromJson(json, SwiftMessage.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwiftMessage that = (SwiftMessage)o;
        return Objects.equals(this.block1, that.block1) && Objects.equals(this.block2, that.block2) && Objects.equals(this.block3, that.block3) && Objects.equals(this.block4, that.block4) && Objects.equals(this.block5, that.block5) && Objects.equals(this.userBlocks, that.userBlocks) && Objects.equals(this.unparsedTexts, that.unparsedTexts);
    }

    public int hashCode() {
        return Objects.hash(this.block1, this.block2, this.block3, this.block4, this.block5, this.userBlocks, this.unparsedTexts);
    }

    public SwiftBlock getBlock(int b) {
        Validate.isTrue((1 <= b && b <= 5 ? 1 : 0) != 0, (String)("block index must be 1-5 (was " + b + ")"), (Object[])new Object[0]);
        switch (b) {
            case 1: {
                return this.block1;
            }
            case 2: {
                return this.block2;
            }
            case 3: {
                return this.block3;
            }
            case 4: {
                return this.block4;
            }
            case 5: {
                return this.block5;
            }
        }
        log.severe("Invalid block number " + b + ". Expected numbers are 1 to 5");
        return null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void addBlock(SwiftBlock b) {
        Objects.requireNonNull(b);
        if (b instanceof SwiftBlockUser) {
            this.addUserBlock((SwiftBlockUser)b);
        } else {
            Objects.requireNonNull(b.getNumber(), "SwiftBlock.getNumber() is null");
            int index = b.getNumber();
            Validate.isTrue((index >= 1 && index <= 5 ? 1 : 0) != 0, (String)"SwiftBlock.getNumber int did not return an int between 1-5", (Object[])new Object[0]);
            switch (index) {
                case 1: {
                    this.setBlock1((SwiftBlock1)b);
                    break;
                }
                case 2: {
                    this.setBlock2((SwiftBlock2)b);
                    break;
                }
                case 3: {
                    this.setBlock3((SwiftBlock3)b);
                    break;
                }
                case 4: {
                    this.setBlock4((SwiftBlock4)b);
                    break;
                }
                case 5: {
                    this.setBlock5((SwiftBlock5)b);
                    break;
                }
                default: {
                    log.severe("Invalid block number " + b + ". Expected numbers are 1 to 5");
                }
            }
        }
    }

    public String getType() {
        if (this.block2 != null) {
            return this.block2.getMessageType();
        }
        return null;
    }

    public void visit(IMessageVisitor visitor) {
        SwiftBlock5 b5;
        SwiftBlock4 b4;
        SwiftBlock3 b3;
        SwiftBlock2 b2;
        Objects.requireNonNull(visitor);
        visitor.startMessage(this);
        SwiftBlock1 b1 = this.block1;
        if (b1 != null) {
            visitor.startBlock1(b1);
            visitor.value(b1, b1.getValue());
            visitor.endBlock1(b1);
        }
        if ((b2 = this.block2) != null) {
            visitor.startBlock2(b2);
            visitor.value(b2, b2.getValue());
            visitor.endBlock2(b2);
        }
        if ((b3 = this.block3) != null) {
            visitor.startBlock3(b3);
            SwiftMessage.visit(b3, visitor);
            visitor.endBlock3(b3);
        }
        if ((b4 = this.block4) != null) {
            visitor.startBlock4(b4);
            SwiftMessage.visit(b4, visitor);
            visitor.endBlock4(b4);
        }
        if ((b5 = this.block5) != null) {
            visitor.startBlock5(b5);
            SwiftMessage.visit(b5, visitor);
            visitor.endBlock5(b5);
        }
        if (this.userBlocks != null) {
            for (SwiftBlockUser userBlock : this.userBlocks) {
                if (userBlock == null) continue;
                visitor.startBlockUser(userBlock);
                SwiftMessage.visit(userBlock, visitor);
                visitor.endBlockUser(userBlock);
            }
        }
        visitor.endMessage(this);
    }

    public int getBlockCount() {
        return this.getBlockCount(Boolean.TRUE);
    }

    public int getBlockCount(Boolean includeUserBlocks) {
        int count = 0;
        if (this.block1 != null && !this.block1.isEmpty()) {
            ++count;
        }
        if (this.block2 != null && !this.block2.isEmpty()) {
            ++count;
        }
        if (this.block3 != null && !this.block3.isEmpty()) {
            ++count;
        }
        if (this.block4 != null && !this.block4.isEmpty()) {
            ++count;
        }
        if (this.block5 != null && !this.block5.isEmpty()) {
            ++count;
        }
        if (includeUserBlocks.booleanValue() && this.userBlocks != null) {
            count += this.userBlocks.size();
        }
        return count;
    }

    public SwiftBlock1 getBlock1() {
        return this.block1;
    }

    public void setBlock1(SwiftBlock1 block1) {
        this.block1 = block1;
    }

    public SwiftBlock2 getBlock2() {
        return this.block2;
    }

    public void setBlock2(SwiftBlock2 block2) {
        this.block2 = block2;
    }

    public SwiftBlock3 getBlock3() {
        return this.block3;
    }

    public void setBlock3(SwiftBlock3 block3) {
        this.block3 = block3;
    }

    public SwiftBlock4 getBlock4() {
        return this.block4;
    }

    public void setBlock4(SwiftBlock4 block4) {
        this.block4 = block4;
    }

    public SwiftBlock5 getBlock5() {
        return this.block5;
    }

    public void setBlock5(SwiftBlock5 block5) {
        this.block5 = block5;
    }

    public int getUserBlockPosition(String blockName) {
        if (StringUtils.isBlank((CharSequence)blockName) || this.userBlocks == null) {
            return -1;
        }
        for (int i = 0; i < this.userBlocks.size(); ++i) {
            SwiftBlockUser userBlock = this.userBlocks.get(i);
            if (userBlock == null || !StringUtils.equals((CharSequence)userBlock.getName(), (CharSequence)blockName)) continue;
            return i;
        }
        return -1;
    }

    public List<SwiftBlockUser> getUserBlocks() {
        return this.userBlocks;
    }

    public void setUserBlocks(List<SwiftBlockUser> userBlocks) {
        Objects.requireNonNull(userBlocks, "parameter 'userBlocks' cannot be null");
        this.userBlocks = userBlocks;
    }

    public SwiftBlockUser getUserBlock(String blockName) {
        Objects.requireNonNull(blockName, "parameter 'blockName' cannot be null");
        int pos = this.getUserBlockPosition(blockName);
        if (pos != -1) {
            return this.userBlocks.get(pos);
        }
        return null;
    }

    public SwiftBlockUser getUserBlock(Integer blockNumber) {
        Objects.requireNonNull(blockNumber, "parameter 'blockNumber' cannot be null");
        return this.getUserBlock(blockNumber.toString());
    }

    public void addUserBlock(SwiftBlockUser userBlock) {
        int pos;
        Objects.requireNonNull(userBlock);
        Validate.isTrue((boolean)userBlock.isValidName(), (String)(INVALID_NAME_BLOCK + userBlock.getName() + ")"), (Object[])new Object[0]);
        if (this.userBlocks == null) {
            this.userBlocks = new ArrayList<SwiftBlockUser>();
        }
        if ((pos = this.getUserBlockPosition(userBlock.getName())) != -1) {
            this.userBlocks.add(pos, userBlock);
        } else {
            this.userBlocks.add(userBlock);
        }
    }

    public void removeUserBlock(Integer blockNumber) {
        Objects.requireNonNull(blockNumber, "parameter 'blockNumber' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockNumber), (String)(INVALID_NAME_BLOCK + blockNumber + ")"), (Object[])new Object[0]);
        this.removeUserBlock(blockNumber.toString());
    }

    public void removeUserBlock(String blockName) {
        Objects.requireNonNull(blockName, "parameter 'blockName' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockName), (String)(INVALID_NAME_BLOCK + blockName + ")"), (Object[])new Object[0]);
        int pos = this.getUserBlockPosition(blockName);
        if (pos != -1) {
            this.userBlocks.remove(pos);
        }
    }

    public void clear() {
        this.block1 = null;
        this.block2 = null;
        this.block3 = null;
        this.block4 = null;
        this.block5 = null;
        this.userBlocks = null;
    }

    public Boolean isFragment() {
        SwiftBlock4 b4 = this.block4;
        if (b4 != null) {
            String t202 = b4.getTagValue("202");
            String t203 = b4.getTagValue("203");
            return t202 != null && t203 != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLastFragment() {
        if (!this.isFragment().booleanValue()) {
            return Boolean.FALSE;
        }
        Integer count = this.fragmentCount();
        try {
            Integer number = this.fragmentNumber();
            return count.intValue() == number.intValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalStateException("Invalid call to islastFragment for a non fragmented message", e);
        }
    }

    public Integer fragmentCount() {
        int _t203;
        if (!this.isFragment().booleanValue()) {
            return 0;
        }
        String t203 = this.block4.getTagValue("203");
        try {
            _t203 = Integer.parseInt(t203, 10);
        }
        catch (NumberFormatException nfe) {
            throw new UnsupportedOperationException(MESSAGE_IS_NOT_A_FRAGMENT);
        }
        return _t203;
    }

    public Integer fragmentNumber() {
        int _t202;
        if (!this.isFragment().booleanValue()) {
            throw new UnsupportedOperationException(MESSAGE_IS_NOT_A_FRAGMENT);
        }
        String t202 = this.block4.getTagValue("202");
        try {
            _t202 = Integer.parseInt(t202, 10);
        }
        catch (NumberFormatException nfe) {
            throw new UnsupportedOperationException(MESSAGE_IS_NOT_A_FRAGMENT);
        }
        return _t202;
    }

    public String getSignature() {
        Tag mdg;
        String signature = null;
        SwiftBlockUser sBlock = this.getUserBlock("S");
        if (sBlock != null && (mdg = sBlock.getTagByName("MDG")) != null) {
            signature = mdg.getValue();
        }
        return signature;
    }

    public SwiftMessage setSignature(String signature) {
        Tag mdg;
        SwiftBlockUser sBlock = this.getUserBlock("S");
        if (sBlock == null) {
            sBlock = new SwiftBlockUser("S");
            this.addUserBlock(sBlock);
        }
        if ((mdg = sBlock.getTagByName("MDG")) == null) {
            mdg = new Tag();
            mdg.setName("MDG");
            sBlock.append(mdg);
        }
        mdg.setValue(signature);
        return this;
    }

    protected void unparsedTextVerify() {
        if (this.unparsedTexts == null) {
            this.unparsedTexts = new UnparsedTextList();
        }
    }

    public UnparsedTextList getUnparsedTexts() {
        this.unparsedTextVerify();
        return this.unparsedTexts;
    }

    public void setUnparsedTexts(UnparsedTextList texts) {
        this.unparsedTexts = texts;
    }

    public Integer getUnparsedTextsSize() {
        if (this.unparsedTexts == null) {
            return 0;
        }
        return this.unparsedTexts.size();
    }

    public Boolean unparsedTextIsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.isMessage(index);
    }

    public String unparsedTextGetText(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getText(index);
    }

    public SwiftMessage unparsedTextGetAsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getTextAsMessage(index);
    }

    public void unparsedTextAddText(String text) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(text);
    }

    public void unparsedTextAddText(SwiftMessage message) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(message);
    }

    public boolean isCOV() {
        if (this.block3 != null) {
            return this.block3.containsTag(Field119.tag(MTVariant.COV.name()));
        }
        return false;
    }

    public boolean isSTP() {
        if (this.block3 != null) {
            return this.block3.containsTag(Field119.tag(MTVariant.STP.name()));
        }
        return false;
    }

    public boolean isREMIT() {
        if (this.block3 != null) {
            return this.block3.containsTag(Field119.tag(MTVariant.REMIT.name()));
        }
        return false;
    }

    public String getSender() {
        return SwiftMessageUtils.sender(this);
    }

    public String getReceiver() {
        return SwiftMessageUtils.receiver(this);
    }

    public List<Field> fields(String ... names) {
        Objects.requireNonNull(names, "names is null");
        ArrayList<Field> result = new ArrayList<Field>();
        for (String n : names) {
            Tag[] tl = this.block4.getTagsByName(n);
            if (tl == null || tl.length <= 0) continue;
            for (Tag t : tl) {
                result.add(t.asField());
            }
        }
        return result;
    }

    public SwiftMessage removeEmptyBlocks() {
        if (this.block1 != null && this.block1.isEmpty()) {
            this.block1 = null;
        }
        if (this.block2 != null && this.block2.isEmpty()) {
            this.block2 = null;
        }
        if (this.block3 != null && this.block3.isEmpty()) {
            this.block3 = null;
        }
        if (this.block4 != null && this.block4.isEmpty()) {
            this.block4 = null;
        }
        if (this.block5 != null && this.block5.isEmpty()) {
            this.block5 = null;
        }
        return this;
    }

    public int getTypeInt() {
        if (this.isServiceMessage()) {
            return -1;
        }
        try {
            return Integer.parseInt(this.getType());
        }
        catch (NumberFormatException e) {
            String text = "Error converting type to int " + this.getType();
            log.warning(text);
            log.log(Level.FINEST, text, e);
            return -1;
        }
    }

    public MessageIOType getDirection() {
        try {
            if (this.block2 == null) {
                log.fine("Requesting direction on a message without block2, can't determine direction. set log level to finer to view more details");
                log.finest("Message: " + this);
            } else {
                if (this.block2.isOutput()) {
                    return MessageIOType.incoming;
                }
                if (this.block2.isInput()) {
                    return MessageIOType.outgoing;
                }
            }
        }
        catch (Exception e) {
            log.severe("Unexpected exception occurred while determining direction from message data: " + e);
        }
        return null;
    }

    public boolean isOutgoing() {
        return this.getDirection() == MessageIOType.outgoing;
    }

    public boolean isInput() {
        return this.isOutgoing();
    }

    public boolean isIncoming() {
        return this.getDirection() == MessageIOType.incoming;
    }

    public boolean isOutput() {
        return this.isIncoming();
    }

    public String getPDE() {
        Optional<Tag> t;
        if (this.block5 != null && (t = this.block5.getTag(SwiftBlock5Field.PDE)).isPresent()) {
            return t.get().getValue();
        }
        return null;
    }

    public SwiftMessage setPDE() {
        if (this.block5 == null) {
            this.block5 = new SwiftBlock5();
        }
        this.block5.setPDE();
        return this;
    }

    public String getPDM() {
        Optional<Tag> t;
        if (this.block5 != null && (t = this.block5.getTag(SwiftBlock5Field.PDM)).isPresent()) {
            return t.get().getValue();
        }
        return null;
    }

    public String getMIR() {
        if (this.block2 != null && this.block2.isOutput()) {
            return ((SwiftBlock2Output)this.block2).getMIR();
        }
        return null;
    }

    public String getMOR() {
        if (this.block2 != null && this.block2.isOutput()) {
            SwiftBlock2Output swiftBlock2Output = (SwiftBlock2Output)this.block2;
            String date = swiftBlock2Output.getReceiverOutputDate();
            if (this.block1 != null) {
                String logicalTerminal = this.block1.getLogicalTerminal();
                String sessionNumber = this.block1.getSessionNumber();
                String sequenceNumber = this.block1.getSequenceNumber();
                MOR mor = new MOR(date, logicalTerminal, sessionNumber, sequenceNumber);
                return mor.getMOR();
            }
        }
        return null;
    }

    public String getMUR() {
        if (this.block3 != null && this.block3.containsTag("108")) {
            return this.block3.getTagValue("108");
        }
        if (this.block4 != null && this.block4.containsTag("108")) {
            return this.block4.getTagValue("108");
        }
        return null;
    }

    public SwiftMessage setMUR(String mur) {
        if (StringUtils.isNotBlank((CharSequence)mur)) {
            if (this.block3 == null) {
                this.block3 = new SwiftBlock3();
            }
            this.block3.builder().setField108(new Field108(mur));
        }
        return this;
    }

    public String getUUID() {
        StringBuilder uuid = new StringBuilder();
        if (this.isIncoming()) {
            uuid.append("O");
        } else {
            uuid.append("I");
        }
        BIC corresp = this.getCorrespondentBIC();
        if (corresp != null) {
            uuid.append(corresp.getBic11());
        }
        uuid.append(StringUtils.trimToEmpty((String)this.getType()));
        uuid.append(StringUtils.trimToEmpty((String)SwiftMessageUtils.reference(this)));
        return uuid.toString();
    }

    public String getUID(Calendar created, Long id) {
        StringBuilder suffix = new StringBuilder();
        if (created != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
            suffix.append(sdf.format(created.getTime()));
        }
        if (id != null) {
            suffix.append(StringUtils.leftPad((String)String.valueOf(id), (int)10, (String)"0"));
        }
        if (suffix.length() == 0) {
            log.warning("The computed suffix for message UID is blank, provide either the creation date or the numeric identifier as parameters for getUID");
        }
        return this.getUUID() + suffix;
    }

    public Field field(String name) {
        List<Field> l = this.fields(name);
        if (l.size() == 0) {
            return null;
        }
        return l.get(0);
    }

    public Boolean isLinked() {
        if (this.block4 != null) {
            return !this.block4.getSubBlock("LINK").isEmpty();
        }
        return null;
    }

    public List<SwiftTagListBlock> getLinkages() {
        if (this.block4 != null) {
            return this.block4.getSubBlocks("LINK");
        }
        return null;
    }

    @Override
    public String toJson() {
        Gson gson = new GsonBuilder().registerTypeAdapter(SwiftMessage.class, (Object)new SwiftMessageAdapter()).registerTypeAdapter(SwiftBlock2.class, (Object)new SwiftBlock2Adapter()).setPrettyPrinting().create();
        return gson.toJson((Object)this);
    }

    public final String toXml() {
        StringWriter w = new StringWriter();
        this.visit(new XMLWriterVisitor(w, true));
        String xml = w.getBuffer().toString();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("xml: " + xml);
        }
        return xml;
    }

    private void appendBlock(String blockName, StringBuilder sb, SwiftTagListBlock b) {
        sb.append("\"block" + blockName + "\" : \n");
        if (b == null) {
            sb.append("{ }");
        } else {
            sb.append(b.toJson());
        }
        sb.append("\n");
    }

    public AbstractMT toMT() {
        String type = this.getType();
        if (type == null) {
            if (this.isServiceMessage21()) {
                return ServiceMessage21.newInstance(this);
            }
            log.warning("Cannot determine the message type from application header (block 2)");
        } else {
            StringBuilder className = new StringBuilder();
            className.append("com.prowidesoftware.swift.model.mt.mt");
            className.append(type.charAt(0));
            className.append("xx.MT");
            className.append(type);
            if (this.isSTP()) {
                if (this.isType(102, 103)) {
                    className.append("_STP");
                } else {
                    log.warning("Unexpected STP flag in MT " + this.getType());
                }
            } else if (this.isREMIT()) {
                if (this.isType(103)) {
                    className.append("_REMIT");
                } else {
                    log.warning("Unexpected REMIT flag in MT " + this.getType());
                }
            } else if (this.isCOV()) {
                if (this.isType(202, 205)) {
                    className.append("COV");
                } else {
                    log.warning("Unexpected COV flag in MT " + this.getType());
                }
            }
            log.finer("About to create an instance of " + className);
            try {
                Class<?> mtClass = Class.forName(className.toString());
                return (AbstractMT)mtClass.getConstructor(SwiftMessage.class).newInstance(this);
            }
            catch (Exception e) {
                log.warning("Could not create instance of " + className + ": " + e);
            }
        }
        return null;
    }

    public boolean isType(int type) {
        return this.getTypeInt() == type;
    }

    public boolean isType(int ... types) {
        int mt = this.getTypeInt();
        for (int t : types) {
            if (mt != t) continue;
            return true;
        }
        return false;
    }

    public final boolean isCategory(MtCategory ... categories) {
        MtCategory cat = this.getCategory();
        for (MtCategory t : categories) {
            if (cat != t) continue;
            return true;
        }
        return false;
    }

    public final MtCategory getCategory() {
        String type = this.getType();
        if (type != null) {
            try {
                return MtCategory.valueOf("_" + type.charAt(0));
            }
            catch (Exception e) {
                String text = "Error extracting category from message type " + this.getType();
                log.warning(text);
                log.log(Level.FINEST, text, e);
            }
        }
        return null;
    }

    public final boolean isServiceMessage() {
        if (this.block1 == null) {
            return false;
        }
        return this.block1.getServiceIdType() != ServiceIdType._01;
    }

    public boolean isServiceMessage21() {
        if (this.block1 == null) {
            return false;
        }
        return this.block1.getServiceIdType() == ServiceIdType._21;
    }

    public boolean isAck() {
        if (this.isServiceMessage21()) {
            if (this.block4 == null) {
                return false;
            }
            return StringUtils.equals((CharSequence)this.block4.getTagValue("451"), (CharSequence)"0");
        }
        return false;
    }

    public boolean isNack() {
        if (this.isServiceMessage21()) {
            if (this.block4 == null) {
                return false;
            }
            return StringUtils.equals((CharSequence)this.block4.getTagValue("451"), (CharSequence)"1");
        }
        return false;
    }

    public MTVariant getVariant() {
        if (this.isCOV()) {
            return MTVariant.COV;
        }
        if (this.isSTP()) {
            return MTVariant.STP;
        }
        if (this.isREMIT()) {
            return MTVariant.REMIT;
        }
        return null;
    }

    public void setVariant(MTVariant variant) {
        if (!variant.isValidationFlag()) {
            log.warning("Field 199 should be used only for validation flags and not for " + variant.name());
        }
        if (this.block3 == null) {
            this.block3 = new SwiftBlock3();
        }
        this.block3.builder().setField119(new Field119(variant.name()));
    }

    public List<String> getTagNames() {
        if (this.block4 == null || this.block4.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Tag t : this.block4.getTags()) {
            if (result.contains(t.getName())) continue;
            result.add(t.getName());
        }
        return result;
    }

    public MtId getMtId() {
        if (this.isServiceMessage()) {
            return null;
        }
        return new MtId(this.getType(), this.getVariant());
    }

    public BIC getCorrespondentBIC() {
        String sender;
        String receiver;
        if (this.isOutgoing() && (receiver = SwiftMessageUtils.receiver(this)) != null) {
            return new BIC(receiver);
        }
        if (this.isIncoming() && (sender = SwiftMessageUtils.sender(this)) != null) {
            return new BIC(sender);
        }
        return null;
    }

    public String getServiceTypeIdentifier() {
        return this.block3 != null ? this.block3.getTagValue("111") : null;
    }

    public void setServiceTypeIdentifier(String serviceTypeIdentifier) {
        if (this.block3 == null) {
            this.block3 = new SwiftBlock3();
        }
        this.block3.builder().setField111(new Field111(serviceTypeIdentifier));
    }

    public String getUETR() {
        return this.block3 != null ? this.block3.getTagValue("121") : null;
    }

    public void setUETR(String uniqueEndToEndTransactionReference) {
        if (this.block3 == null) {
            this.block3 = new SwiftBlock3();
        }
        this.block3.builder().setField121(new Field121(uniqueEndToEndTransactionReference));
    }

    public String setUETR() {
        String uuid36 = UETRUtils.generate();
        this.setUETR(uuid36);
        return uuid36;
    }

    public boolean isGpi() {
        return this.isType(103, 199, 299, 192, 196) || this.isType(202, 205) && this.isCOV();
    }

    public String message() {
        ConversionService srv = new ConversionService();
        return srv.getFIN(this);
    }
}

