/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.AbstractSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessageStatusInfo;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import java.util.Calendar;
import java.util.Objects;

@Entity
@Table(name="swift_msg_revision")
public class SwiftMessageRevision {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="creation_date")
    private Calendar creationDate = Calendar.getInstance();
    @Column(length=40, name="creation_user")
    private String creationUser;
    @Lob
    private String message;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    private String json;

    public SwiftMessageRevision() {
    }

    public SwiftMessageRevision(AbstractSwiftMessage msg) {
        SwiftMessageStatusInfo status = msg.getStatusInfo();
        if (status != null) {
            this.creationDate = status.getCreationDate();
            this.creationUser = status.getCreationUser();
        }
        this.message = msg.message();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwiftMessageRevision that = (SwiftMessageRevision)o;
        return Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.creationUser, that.creationUser) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.creationDate, this.creationUser, this.message);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public String getCreationUser() {
        return this.creationUser;
    }

    public void setCreationUser(String creationUser) {
        this.creationUser = creationUser;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }
}

