/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.selenium.client.client.factory;

import com.saucelabs.selenium.client.client.factory.spi.SeleniumFactorySPI;
import com.thoughtworks.selenium.Selenium;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumFactory {
    private String uri;
    private ClassLoader cl = Thread.currentThread().getContextClassLoader();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private static final Logger LOGGER = Logger.getLogger(SeleniumFactory.class.getName());

    public static Selenium create() {
        return new SeleniumFactory().createSelenium();
    }

    public static Selenium create(String browserURL) {
        return new SeleniumFactory().createSelenium(browserURL);
    }

    public static Selenium create(String driverUri, String browserURL) {
        return new SeleniumFactory().setUri(driverUri).createSelenium(browserURL);
    }

    public SeleniumFactory() {
        this.uri = SeleniumFactory.readPropertyOrEnv("SELENIUM_DRIVER", SeleniumFactory.readPropertyOrEnv("DEFAULT_SELENIUM_DRIVER", "embedded-rc:"));
    }

    private static String readPropertyOrEnv(String key, String defaultValue) {
        String v = System.getProperty(key);
        if (v == null) {
            v = System.getenv(key);
        }
        if (v == null) {
            v = defaultValue;
        }
        return v;
    }

    public String getUri() {
        return this.uri;
    }

    public SeleniumFactory setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public SeleniumFactory setClassLoader(ClassLoader cl) {
        this.cl = cl;
        return this;
    }

    public SeleniumFactory setProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public SeleniumFactory clone() {
        SeleniumFactory f = new SeleniumFactory();
        f.uri = this.uri;
        f.cl = this.cl;
        f.properties.clear();
        f.properties.putAll(this.properties);
        return f;
    }

    public Selenium createSelenium() {
        String url = SeleniumFactory.readPropertyOrEnv("SELENIUM_STARTING_URL", SeleniumFactory.readPropertyOrEnv("DEFAULT_SELENIUM_STARTING_URL", null));
        if (url == null) {
            throw new IllegalArgumentException("Neither SELENIUM_STARTING_URL system property nor environment variable exists");
        }
        return this.createSelenium(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Selenium createSelenium(String browserURL) {
        try {
            if (this.uri == null) {
                throw new IllegalArgumentException("Selenium driver URI is not set");
            }
            Enumeration<URL> e = this.cl.getResources("META-INF/services/" + SeleniumFactorySPI.class.getName());
            block11: while (true) {
                if (!e.hasMoreElements()) {
                    throw new IllegalArgumentException(String.format("Unrecognized Selenium driver URI '%s'. Make sure you got the proper driver jars in your classpath, or increase the logging level to get more information.", this.uri));
                }
                URL url = e.nextElement();
                LOGGER.fine("Reading " + url + " looking for " + SeleniumFactorySPI.class.getName());
                LineNumberReader in = new LineNumberReader(new InputStreamReader(url.openStream(), "UTF-8"));
                try {
                    while (true) {
                        Class<?> c;
                        String line;
                        if ((line = ((BufferedReader)in).readLine()) == null) continue block11;
                        if ((line = line.trim()).startsWith("#")) continue;
                        LOGGER.fine("Found " + line);
                        try {
                            c = this.cl.loadClass(line);
                            LOGGER.fine("Loaded " + c);
                            Object _spi = c.newInstance();
                            if (_spi instanceof SeleniumFactorySPI) {
                                SeleniumFactorySPI spi = (SeleniumFactorySPI)_spi;
                                Selenium selenium = spi.createSelenium(this, browserURL);
                                if (selenium == null) continue;
                                Selenium selenium2 = selenium;
                                return selenium2;
                            }
                        }
                        catch (ClassNotFoundException x) {
                            LOGGER.log(Level.WARNING, url + " specifies an SPI class " + line + " but the class failed to load", x);
                        }
                        catch (InstantiationException x) {
                            LOGGER.log(Level.WARNING, url + " specifies an SPI class " + line + " but the class failed to instantiate", x);
                        }
                        catch (IllegalAccessException x) {
                            LOGGER.log(Level.WARNING, url + " specifies an SPI class " + line + " but the class failed to instantiate", x);
                        }
                        {
                            URL img = c.getClassLoader().getResource(SeleniumFactorySPI.class.getName().replace('.', '/') + ".class");
                            LOGGER.log(Level.WARNING, url + " specifies an SPI class " + line + " but the class isn't assignable to " + SeleniumFactorySPI.class + ". It's loading SPI from " + img);
                        }
                    }
                }
                finally {
                    in.close();
                    continue;
                }
                break;
            }
        }
        catch (IOException x) {
            throw new IllegalArgumentException("Failed to instantiate the driver", x);
        }
    }
}

