/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.selenium.client.client.logging;

import com.saucelabs.selenium.client.client.logging.LoggingSelenium;
import com.thoughtworks.selenium.Selenium;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingSeleniumProxy
implements InvocationHandler,
LoggingSelenium {
    private Selenium base;
    private Logger logger = Logger.getLogger(LoggingSeleniumProxy.class.getName());
    private Level level = Level.INFO;
    private String id = "Selenium" + Integer.toHexString(this.hashCode());

    public LoggingSeleniumProxy(Selenium base) {
        this.base = base;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> decl = method.getDeclaringClass();
        if (decl == Object.class || decl == LoggingSelenium.class) {
            return method.invoke((Object)this, args);
        }
        StringBuilder buf = new StringBuilder();
        try {
            buf.append(this.id).append(": ");
            buf.append(method.getName()).append('(');
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        buf.append(',');
                    }
                    this.appendValue(args[i], buf);
                }
            }
            buf.append(')');
            Object r = method.invoke((Object)this.base, args);
            if (method.getReturnType() != Void.TYPE) {
                buf.append(" -> ");
                this.appendValue(r, buf);
            }
            this.logger.log(this.level, buf.toString());
            return r;
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            this.logger.log(this.level, buf.toString(), target);
            throw target;
        }
    }

    private void appendValue(Object o, StringBuilder buf) {
        if (o instanceof String) {
            buf.append('\"').append(o).append('\"');
        } else {
            buf.append(o);
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogLevel(Level level) {
        this.level = level;
    }

    public Level getLogLevel() {
        return this.level;
    }

    public Selenium getBaseDriver() {
        return this.base;
    }

    public void setBaseDriver(Selenium selenium) {
        this.base = selenium;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return "Logging Selenium driver around " + this.base;
    }
}

