/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.sample;

import io.dropwizard.Application;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.auth.AuthDynamicFeature;
import io.dropwizard.auth.AuthValueFactoryProvider;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.PrincipalImpl;
import io.dropwizard.auth.basic.BasicCredentialAuthFilter;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.federecio.dropwizard.sample.SampleAuthenticator;
import io.federecio.dropwizard.sample.SampleConfiguration;
import io.federecio.dropwizard.sample.SampleResource;
import io.federecio.dropwizard.swagger.SwaggerBundle;
import io.federecio.dropwizard.swagger.SwaggerBundleConfiguration;
import javax.ws.rs.container.ContainerRequestFilter;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;

public class SampleApplication
extends Application<SampleConfiguration> {
    public static void main(String[] args) throws Exception {
        new SampleApplication().run(args);
    }

    public String getName() {
        return "sample";
    }

    public void initialize(Bootstrap<SampleConfiguration> bootstrap) {
        bootstrap.addBundle((ConfiguredBundle)new SwaggerBundle<SampleConfiguration>(){

            @Override
            protected SwaggerBundleConfiguration getSwaggerBundleConfiguration(SampleConfiguration configuration) {
                return configuration.getSwagger();
            }
        });
    }

    public void run(SampleConfiguration configuration, Environment environment) throws Exception {
        environment.jersey().register((Object)new AuthDynamicFeature((ContainerRequestFilter)new BasicCredentialAuthFilter.Builder().setAuthenticator((Authenticator)new SampleAuthenticator()).setRealm("SUPER SECRET STUFF").buildAuthFilter()));
        environment.jersey().register(RolesAllowedDynamicFeature.class);
        environment.jersey().register((Object)new AuthValueFactoryProvider.Binder(PrincipalImpl.class));
        environment.jersey().register((Object)new SampleResource());
    }
}

