/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.swagger;

import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.views.ViewBundle;
import io.federecio.dropwizard.swagger.AuthParamFilter;
import io.federecio.dropwizard.swagger.ConfigurationHelper;
import io.federecio.dropwizard.swagger.SwaggerBundleConfiguration;
import io.federecio.dropwizard.swagger.SwaggerResource;
import io.swagger.config.FilterFactory;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverters;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.jackson.ModelResolver;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;

public abstract class SwaggerBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    public void initialize(Bootstrap<?> bootstrap) {
        bootstrap.addBundle((ConfiguredBundle)new ViewBundle());
        ModelConverters.getInstance().addConverter((ModelConverter)new ModelResolver(bootstrap.getObjectMapper()));
    }

    public void run(T configuration, Environment environment) throws Exception {
        SwaggerBundleConfiguration swaggerBundleConfiguration = this.getSwaggerBundleConfiguration(configuration);
        if (swaggerBundleConfiguration == null) {
            throw new IllegalStateException("You need to provide an instance of SwaggerBundleConfiguration");
        }
        if (!swaggerBundleConfiguration.isEnabled()) {
            return;
        }
        ConfigurationHelper configurationHelper = new ConfigurationHelper((Configuration)configuration, swaggerBundleConfiguration);
        new AssetsBundle("/swagger-static", configurationHelper.getSwaggerUriPath(), null, "swagger-assets").run(environment);
        swaggerBundleConfiguration.build(configurationHelper.getUrlPattern());
        FilterFactory.setFilter((SwaggerSpecFilter)new AuthParamFilter());
        environment.jersey().register((Object)new ApiListingResource());
        environment.jersey().register((Object)new SwaggerSerializers());
        if (swaggerBundleConfiguration.isIncludeSwaggerResource()) {
            environment.jersey().register((Object)new SwaggerResource(configurationHelper.getUrlPattern(), swaggerBundleConfiguration.getSwaggerViewConfiguration(), swaggerBundleConfiguration.getContextRoot()));
        }
    }

    protected abstract SwaggerBundleConfiguration getSwaggerBundleConfiguration(T var1);
}

