/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.swagger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import io.federecio.dropwizard.swagger.SwaggerViewConfiguration;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.models.Contact;
import org.hibernate.validator.constraints.NotEmpty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SwaggerBundleConfiguration {
    @NotEmpty
    private String resourcePackage;
    private String title;
    private String version;
    private String description;
    private String termsOfServiceUrl;
    private String contact;
    private String contactEmail;
    private String contactUrl;
    private String license;
    private String licenseUrl;
    private SwaggerViewConfiguration swaggerViewConfiguration = new SwaggerViewConfiguration();
    private boolean prettyPrint = true;
    private String host;
    private String contextRoot = "/";
    private String[] schemes = new String[]{"http"};
    private boolean enabled = true;
    private boolean includeSwaggerResource = true;
    @JsonProperty
    private String uriPrefix;

    @JsonProperty
    public String getResourcePackage() {
        return this.resourcePackage;
    }

    @JsonProperty
    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @JsonProperty
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty
    public String getTermsOfServiceUrl() {
        return this.termsOfServiceUrl;
    }

    @JsonProperty
    public void setTermsOfServiceUrl(String termsOfServiceUrl) {
        this.termsOfServiceUrl = termsOfServiceUrl;
    }

    @JsonProperty
    public String getContact() {
        return this.contact;
    }

    @JsonProperty
    public void setContact(String contact) {
        this.contact = contact;
    }

    @JsonProperty
    public String getContactEmail() {
        return this.contactEmail;
    }

    @JsonProperty
    public void setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
    }

    @JsonProperty
    public String getContactUrl() {
        return this.contactUrl;
    }

    @JsonProperty
    public void setContactUrl(String contactUrl) {
        this.contactUrl = contactUrl;
    }

    @JsonProperty
    public String getLicense() {
        return this.license;
    }

    @JsonProperty
    public void setLicense(String license) {
        this.license = license;
    }

    @JsonProperty
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    @JsonProperty
    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    @JsonProperty
    public String getUriPrefix() {
        return this.uriPrefix;
    }

    @JsonProperty
    public void setUriPrefix(String uriPrefix) {
        this.uriPrefix = uriPrefix;
    }

    @JsonProperty
    public SwaggerViewConfiguration getSwaggerViewConfiguration() {
        return this.swaggerViewConfiguration;
    }

    @JsonProperty
    public void setSwaggerViewConfiguration(SwaggerViewConfiguration swaggerViewConfiguration) {
        this.swaggerViewConfiguration = swaggerViewConfiguration;
    }

    @JsonProperty
    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @JsonProperty
    public void setIsPrettyPrint(boolean isPrettyPrint) {
        this.prettyPrint = isPrettyPrint;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public void setHost(String host) {
        this.host = host;
    }

    @JsonProperty
    public String getContextRoot() {
        return this.contextRoot;
    }

    @JsonProperty
    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    @JsonProperty
    public String[] getSchemes() {
        return this.schemes;
    }

    @JsonProperty
    public void setSchemes(String[] schemes) {
        this.schemes = schemes;
    }

    @JsonProperty
    public boolean isEnabled() {
        return this.enabled;
    }

    @JsonProperty
    public void setIsEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    @JsonProperty
    public boolean isIncludeSwaggerResource() {
        return this.includeSwaggerResource;
    }

    @JsonProperty
    public void setIncludeSwaggerResource(boolean include) {
        this.includeSwaggerResource = include;
    }

    @JsonIgnore
    public BeanConfig build(String urlPattern) {
        if (Strings.isNullOrEmpty((String)this.resourcePackage)) {
            throw new IllegalStateException("Resource package needs to be specified for Swagger to correctly detect annotated resources");
        }
        BeanConfig config = new BeanConfig();
        config.setTitle(this.title);
        config.setVersion(this.version);
        config.setDescription(this.description);
        config.setContact(this.contact);
        config.setLicense(this.license);
        config.setLicenseUrl(this.licenseUrl);
        config.setTermsOfServiceUrl(this.termsOfServiceUrl);
        config.setPrettyPrint(this.prettyPrint);
        config.setBasePath(("/".equals(this.contextRoot) ? "" : this.contextRoot) + urlPattern);
        config.setResourcePackage(this.resourcePackage);
        config.setSchemes(this.schemes);
        config.setHost(this.host);
        config.setScan(true);
        if (this.contactEmail != null || this.contactUrl != null) {
            if (config.getInfo().getContact() == null) {
                config.getInfo().setContact(new Contact());
            }
            if (this.contactEmail != null) {
                config.getInfo().getContact().setEmail(this.contactEmail);
            }
            if (this.contactUrl != null) {
                config.getInfo().getContact().setUrl(this.contactUrl);
            }
        }
        return config;
    }
}

