/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.connector.sqlite.internal;

import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.ExecuteBefore;
import com.speedment.common.injector.annotation.Inject;
import com.speedment.common.injector.annotation.OnlyIfMissing;
import com.speedment.runtime.connector.sqlite.SqliteMetadataHandler;
import com.speedment.runtime.connector.sqlite.SqliteOperationHandler;
import com.speedment.runtime.connector.sqlite.internal.SqliteColumnHandler;
import com.speedment.runtime.connector.sqlite.internal.SqliteConnectionUrlGenerator;
import com.speedment.runtime.connector.sqlite.internal.SqliteFieldPredicateView;
import com.speedment.runtime.connector.sqlite.internal.SqliteNamingConvention;
import com.speedment.runtime.connector.sqlite.internal.SqliteOperationHandlerImpl;
import com.speedment.runtime.core.component.connectionpool.ConnectionPoolComponent;
import com.speedment.runtime.core.component.transaction.TransactionComponent;
import com.speedment.runtime.core.db.ConnectionUrlGenerator;
import com.speedment.runtime.core.db.DatabaseNamingConvention;
import com.speedment.runtime.core.db.DbmsColumnHandler;
import com.speedment.runtime.core.db.DbmsMetadataHandler;
import com.speedment.runtime.core.db.DbmsOperationHandler;
import com.speedment.runtime.core.db.DbmsType;
import com.speedment.runtime.core.db.DbmsTypeDefault;
import com.speedment.runtime.core.db.DriverComponent;
import com.speedment.runtime.core.db.FieldPredicateView;
import com.speedment.runtime.core.db.metadata.TypeInfoMetaData;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class SqliteDbmsTypeImpl
implements DbmsType {
    static final String SQLITE = "SQLite";
    private final DriverComponent drivers;
    private final SqliteMetadataHandler metadataHandler;
    private final SqliteOperationHandler operationHandler;

    @Inject
    @OnlyIfMissing(value={DriverComponent.class})
    public SqliteDbmsTypeImpl(SqliteMetadataHandler metadataHandler, ConnectionPoolComponent connectionPoolComponent, TransactionComponent transactionComponent) {
        this.drivers = null;
        this.metadataHandler = Objects.requireNonNull(metadataHandler);
        this.operationHandler = new SqliteOperationHandlerImpl(connectionPoolComponent, transactionComponent);
    }

    @Inject
    public SqliteDbmsTypeImpl(DriverComponent drivers, SqliteMetadataHandler metadataHandler, ConnectionPoolComponent connectionPoolComponent, TransactionComponent transactionComponent) {
        this.drivers = Objects.requireNonNull(drivers);
        this.metadataHandler = Objects.requireNonNull(metadataHandler);
        this.operationHandler = new SqliteOperationHandlerImpl(connectionPoolComponent, transactionComponent);
    }

    @ExecuteBefore(value=State.STOPPED)
    public void close() {
        this.operationHandler.close();
    }

    public boolean hasSchemaNames() {
        return false;
    }

    public boolean hasDatabaseNames() {
        return false;
    }

    public boolean hasDatabaseUsers() {
        return false;
    }

    public String getName() {
        return SQLITE;
    }

    public String getDriverManagerName() {
        return "SQLite JDBC Driver";
    }

    public DbmsTypeDefault.ConnectionType getConnectionType() {
        return DbmsTypeDefault.ConnectionType.DBMS_AS_FILE;
    }

    public int getDefaultPort() {
        return 0;
    }

    public String getSchemaTableDelimiter() {
        return "";
    }

    public String getDbmsNameMeaning() {
        return "The name of the file where data is persisted.";
    }

    public Optional<String> getDefaultDbmsName() {
        return Optional.empty();
    }

    public boolean isSupported() {
        return this.drivers != null && this.drivers.driver(this.getDriverName()).isPresent();
    }

    public String getDriverName() {
        return "org.sqlite.JDBC";
    }

    public DatabaseNamingConvention getDatabaseNamingConvention() {
        return new SqliteNamingConvention();
    }

    public DbmsMetadataHandler getMetadataHandler() {
        return this.metadataHandler;
    }

    public DbmsOperationHandler getOperationHandler() {
        return this.operationHandler;
    }

    public DbmsColumnHandler getColumnHandler() {
        return new SqliteColumnHandler();
    }

    public String getResultSetTableSchema() {
        throw new UnsupportedOperationException("SQLite does not have concept of 'schemas', so this method should not be invoked.");
    }

    public ConnectionUrlGenerator getConnectionUrlGenerator() {
        return new SqliteConnectionUrlGenerator();
    }

    public FieldPredicateView getFieldPredicateView() {
        return new SqliteFieldPredicateView();
    }

    public Set<TypeInfoMetaData> getDataTypes() {
        return Collections.emptySet();
    }

    public String getInitialQuery() {
        return "SELECT 1";
    }

    public DbmsTypeDefault.SkipLimitSupport getSkipLimitSupport() {
        return DbmsTypeDefault.SkipLimitSupport.STANDARD;
    }

    public String applySkipLimit(String originalSql, List<Object> params, long skip, long limit) {
        if (skip == 0L && limit == Long.MAX_VALUE) {
            return originalSql;
        }
        StringBuilder sb = new StringBuilder(originalSql);
        if (limit == Long.MAX_VALUE) {
            sb.append(" LIMIT 223372036854775807");
        } else {
            sb.append(" LIMIT ?");
            params.add(limit);
        }
        if (skip > 0L) {
            sb.append(" OFFSET ?");
            params.add(skip);
        }
        return sb.toString();
    }

    public DbmsTypeDefault.SubSelectAlias getSubSelectAlias() {
        return DbmsTypeDefault.SubSelectAlias.PROHIBITED;
    }

    public DbmsTypeDefault.SortByNullOrderInsertion getSortByNullOrderInsertion() {
        return DbmsTypeDefault.SortByNullOrderInsertion.PRE;
    }
}

