/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.connector.sqlite.internal;

import com.speedment.common.injector.Injector;
import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.ExecuteBefore;
import com.speedment.common.invariant.NullUtil;
import com.speedment.common.logger.Logger;
import com.speedment.common.logger.LoggerManager;
import com.speedment.runtime.config.Column;
import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.ForeignKey;
import com.speedment.runtime.config.ForeignKeyColumn;
import com.speedment.runtime.config.Index;
import com.speedment.runtime.config.IndexColumn;
import com.speedment.runtime.config.PrimaryKeyColumn;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.Schema;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.mutator.ForeignKeyColumnMutator;
import com.speedment.runtime.config.mutator.IndexMutator;
import com.speedment.runtime.config.mutator.TableMutator;
import com.speedment.runtime.config.trait.HasId;
import com.speedment.runtime.config.util.DocumentDbUtil;
import com.speedment.runtime.config.util.DocumentUtil;
import com.speedment.runtime.connector.sqlite.internal.SqliteNamingConvention;
import com.speedment.runtime.connector.sqlite.internal.types.SqlTypeMappingHelper;
import com.speedment.runtime.connector.sqlite.internal.util.LoggingUtil;
import com.speedment.runtime.connector.sqlite.internal.util.MetaDataUtil;
import com.speedment.runtime.core.component.ProjectComponent;
import com.speedment.runtime.core.component.connectionpool.ConnectionPoolComponent;
import com.speedment.runtime.core.component.connectionpool.PoolableConnection;
import com.speedment.runtime.core.db.DbmsMetadataHandler;
import com.speedment.runtime.core.db.JavaTypeMap;
import com.speedment.runtime.core.db.SqlFunction;
import com.speedment.runtime.core.db.SqlPredicate;
import com.speedment.runtime.core.db.SqlSupplier;
import com.speedment.runtime.core.db.metadata.ColumnMetaData;
import com.speedment.runtime.core.exception.SpeedmentException;
import com.speedment.runtime.core.util.ProgressMeasure;
import com.speedment.runtime.typemapper.TypeMapper;
import com.speedment.runtime.typemapper.primitive.PrimitiveTypeMapper;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SqliteMetadataHandlerImpl
implements DbmsMetadataHandler {
    private static final Logger LOGGER = LoggerManager.getLogger(SqliteMetadataHandlerImpl.class);
    private static final String[] TABLES_AND_VIEWS = new String[]{"TABLE", "VIEW"};
    private static final String ORIGINAL_TYPE = "originalDatabaseType";
    private static final String ROW_ID = "rowid";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String KEY_SEQ = "KEY_SEQ";
    private static final String INDEX_NAME = "INDEX_NAME";
    private static final String SCHEMA = "schema";
    private static final Pattern BINARY_TYPES = Pattern.compile("^(?:(?:TINY|MEDIUM|LONG)?\\s?BLOB|(?:VAR)?BINARY)(?:\\(\\d+\\))?$");
    private static final Pattern INTEGER_BOOLEAN_TYPE = Pattern.compile("^(?:BIT|INT|INTEGER|TINYINT)\\(1\\)$");
    private static final Pattern BIT_TYPES = Pattern.compile("^BIT\\((\\d+)\\)$");
    private static final Pattern SHORT_TYPES = Pattern.compile("^(?:UNSIGNED\\s+TINY\\s?INT|SHORT(?:\\s?INT)?)(?:\\((\\d+)\\))?$");
    private static final Pattern INT_TYPES = Pattern.compile("^(?:UNSIGNED (?:SHORT|MEDIUM\\s?INT)|INT(?:EGER)?|MEDIUM\\s?INT)(?:\\((\\d+)\\))?$");
    private static final Pattern LONG_TYPES = Pattern.compile("^(?:UNSIGNED(?: INT(?:EGER)?)|(?:UNSIGNED\\s*)?(?:BIG\\s?INT|LONG))(?:\\((\\d+)\\))?$");
    private static final boolean IGNORE_VIEW_INDEXES = false;
    private static final boolean APPROXIMATE_INDEX = true;
    private final ConnectionPoolComponent connectionPool;
    private final ProjectComponent projects;
    private final JavaTypeMap javaTypeMap;
    private SqlTypeMappingHelper typeMappingHelper;

    public SqliteMetadataHandlerImpl(ConnectionPoolComponent connectionPool, ProjectComponent projects) {
        this.connectionPool = connectionPool;
        this.projects = projects;
        this.javaTypeMap = JavaTypeMap.create();
        this.javaTypeMap.addRule((mappings, md) -> md.getTypeName().toUpperCase().startsWith("NUMERIC(") ? Optional.of(Double.class) : Optional.empty());
        this.javaTypeMap.addRule((mappings, md) -> md.getTypeName().toUpperCase().startsWith("DECIMAL(") ? Optional.of(Double.class) : Optional.empty());
        this.javaTypeMap.addRule((mappings, md) -> Optional.of(md.getTypeName()).map(String::toUpperCase).filter(str -> INTEGER_BOOLEAN_TYPE.matcher((CharSequence)str).find()).map(str -> Boolean.class));
        this.javaTypeMap.addRule((mappings, md) -> SqliteMetadataHandlerImpl.patternMapper(SHORT_TYPES, md, Short.class));
        this.javaTypeMap.addRule((mappings, md) -> SqliteMetadataHandlerImpl.patternMapper(LONG_TYPES, md, Long.class));
        this.javaTypeMap.addRule((mappings, md) -> SqliteMetadataHandlerImpl.patternMapper(INT_TYPES, md, Integer.class));
        this.javaTypeMap.addRule((mappings, md) -> Optional.of(md.getTypeName()).map(String::toUpperCase).map(BIT_TYPES::matcher).filter(Matcher::find).map(match -> match.group(1)).map(Integer::parseInt).map(bits -> {
            if (bits > 32) {
                return Long.class;
            }
            if (bits > 16) {
                return Integer.class;
            }
            if (bits > 8) {
                return Short.class;
            }
            return Byte.class;
        }));
        this.javaTypeMap.addRule((mappings, md) -> Optional.of(md.getTypeName()).map(String::toUpperCase).filter(str -> BINARY_TYPES.matcher((CharSequence)str).find()).map(str -> byte[].class));
    }

    @ExecuteBefore(value=State.RESOLVED)
    public void initSqlTypeMappingHelper(Injector injector) {
        this.typeMappingHelper = SqlTypeMappingHelper.create(injector, this.javaTypeMap);
    }

    public String getDbmsInfoString(Dbms dbms) throws SQLException {
        try (PoolableConnection conn = this.connectionPool.getConnection(dbms);){
            DatabaseMetaData md = conn.getMetaData();
            String string = md.getDatabaseProductName() + ", " + md.getDatabaseProductVersion() + ", " + md.getDriverName() + " " + md.getDriverVersion() + ", JDBC version " + md.getJDBCMajorVersion() + "." + md.getJDBCMinorVersion();
            return string;
        }
    }

    public CompletableFuture<Project> readSchemaMetadata(Dbms dbms, ProgressMeasure progress, Predicate<String> filterCriteria) {
        Project projectCopy = this.projects.getProject().deepCopy();
        HashSet ids = new HashSet();
        if (!projectCopy.dbmses().map(HasId::getId).allMatch(ids::add)) {
            HashSet duplicates = new HashSet();
            ids.clear();
            projectCopy.dbmses().map(HasId::getId).forEach(s -> {
                if (!ids.add(s)) {
                    duplicates.add(s);
                }
            });
            throw new SpeedmentException("The following dbmses have duplicates in the config document: " + duplicates);
        }
        Dbms dbmsCopy = projectCopy.dbmses().filter(d -> d.getId().equals(dbms.getId())).findAny().orElseThrow(() -> new SpeedmentException("Could not find Dbms document in copy."));
        return this.readSchemaMetadata(projectCopy, dbmsCopy, progress).whenCompleteAsync((project, ex) -> {
            progress.setProgress(1.0);
            if (ex != null) {
                progress.setCurrentAction("Error!");
                throw new SpeedmentException("Unable to read schema metadata.", ex);
            }
            progress.setCurrentAction("Done!");
        });
    }

    private CompletableFuture<Project> readSchemaMetadata(Project project, Dbms dbms, ProgressMeasure progress) {
        progress.setCurrentAction(LoggingUtil.describe(dbms));
        LOGGER.info(LoggingUtil.describe(dbms));
        CompletableFuture<Map<String, Class<?>>> typeMappingTask = this.typeMappingHelper.loadFor(dbms);
        Schema schema = dbms.mutator().addNewSchema();
        schema.mutator().setId(SCHEMA);
        schema.mutator().setName(SCHEMA);
        return this.readTableMetadata(schema, typeMappingTask, progress).thenApplyAsync($ -> project);
    }

    private CompletableFuture<Schema> readTableMetadata(Schema schema, CompletableFuture<Map<String, Class<?>>> typeMappingTask, ProgressMeasure progress) {
        CompletableFuture<Void> tablesTask = CompletableFuture.runAsync(() -> this.tablesTask(schema));
        return ((CompletableFuture)tablesTask.thenComposeAsync($ -> typeMappingTask)).thenComposeAsync(sqlTypeMappings -> {
            Dbms dbms = (Dbms)schema.getParentOrThrow();
            AtomicInteger cnt = new AtomicInteger();
            double noTables = schema.tables().count();
            return CompletableFuture.allOf((CompletableFuture[])schema.tables().map(table -> CompletableFuture.runAsync(() -> {
                try (PoolableConnection conn = this.connectionPool.getConnection(dbms);){
                    progress.setCurrentAction(LoggingUtil.describe(table));
                    this.columns((Connection)conn, (Map<String, Class<?>>)sqlTypeMappings, (Table)table, progress);
                    this.indexes((Connection)conn, (Table)table, progress);
                    this.foreignKeys((Connection)conn, (Table)table);
                    this.primaryKeyColumns((Connection)conn, (Table)table, progress);
                    if (!table.isView()) {
                        if (table.columns().filter(col -> col.getAsString(ORIGINAL_TYPE).filter("INTEGER"::equalsIgnoreCase).isPresent()).noneMatch(col -> table.primaryKeyColumns().anyMatch(pkc -> DocumentDbUtil.isSame((Column)pkc.findColumnOrThrow(), (Column)col))) && table.columns().map(HasId::getId).noneMatch(ROW_ID::equalsIgnoreCase)) {
                            this.createRowId((Table)table);
                        } else {
                            table.columns().filter(col -> col.getAsString(ORIGINAL_TYPE).filter("INTEGER"::equalsIgnoreCase).isPresent()).filter(col -> table.primaryKeyColumns().anyMatch(pkc -> DocumentDbUtil.isSame((Column)pkc.findColumnOrThrow(), (Column)col))).forEach(col -> col.mutator().setAutoIncrement(Boolean.valueOf(true)));
                        }
                    }
                    table.columns().forEach(col -> col.getData().remove(ORIGINAL_TYPE));
                    progress.setProgress((double)cnt.incrementAndGet() / noTables);
                }
                catch (SQLException ex) {
                    throw new SpeedmentException((Throwable)ex);
                }
            })).toArray(CompletableFuture[]::new)).thenApplyAsync(v -> schema);
        });
    }

    private static Optional<Class<?>> patternMapper(Pattern pattern, ColumnMetaData md, Class<?> expected) {
        return Optional.of(md.getTypeName()).map(String::toUpperCase).map(pattern::matcher).filter(Matcher::find).map(match -> {
            String group = match.group(1);
            if (group == null) {
                return expected;
            }
            int digits = Integer.parseInt(group);
            if (digits > 11) {
                return Long.class;
            }
            if (digits > 4) {
                return Integer.class;
            }
            if (digits > 2) {
                return Short.class;
            }
            return Byte.class;
        });
    }

    private void tablesTask(Schema schema) {
        Dbms dbms = (Dbms)schema.getParentOrThrow();
        try (PoolableConnection connection = this.connectionPool.getConnection(dbms);){
            try (ResultSet rsTable = connection.getMetaData().getTables(null, null, null, TABLES_AND_VIEWS);){
                while (rsTable.next()) {
                    Table table = schema.mutator().addNewTable();
                    String tableName = rsTable.getString("TABLE_NAME");
                    String tableType = rsTable.getString("TABLE_TYPE");
                    table.mutator().setId(tableName);
                    table.mutator().setName(tableName);
                    table.mutator().setView("VIEW".equals(tableType));
                }
            }
            catch (SQLException ex) {
                throw new SpeedmentException(String.format("Error reading results from SQLite-database '%s'.", DocumentUtil.toStringHelper((Document)dbms)), (Throwable)ex);
            }
        }
        catch (SQLException ex) {
            throw new SpeedmentException(String.format("Error getting connection to SQLite-database '%s'.", DocumentUtil.toStringHelper((Document)dbms)), (Throwable)ex);
        }
    }

    private void createRowId(Table table) {
        Column column = table.mutator().addNewColumn();
        column.mutator().setId(ROW_ID);
        column.mutator().setName(ROW_ID);
        column.mutator().setOrdinalPosition(Integer.valueOf(0));
        column.mutator().setDatabaseType(Long.class);
        column.mutator().setAutoIncrement(Boolean.valueOf(true));
        column.mutator().setNullable(Boolean.valueOf(false));
        column.mutator().setTypeMapper(PrimitiveTypeMapper.class);
        if (table.primaryKeyColumns().anyMatch(pkc -> true)) {
            Set oldPks = table.primaryKeyColumns().map(HasId::getId).collect(Collectors.toCollection(LinkedHashSet::new));
            if (table.indexes().filter(Index::isUnique).noneMatch(idx -> oldPks.equals(idx.indexColumns().map(HasId::getId).collect(Collectors.toCollection(LinkedHashSet::new))))) {
                this.addUniqueIndex(table, oldPks);
            }
            table.getData().remove("primaryKeyColumns");
        }
        PrimaryKeyColumn pkc2 = table.mutator().addNewPrimaryKeyColumn();
        pkc2.mutator().setId(ROW_ID);
        pkc2.mutator().setName(ROW_ID);
        pkc2.mutator().setOrdinalPosition(Integer.valueOf(1));
    }

    private void addUniqueIndex(Table table, Set<String> oldPks) {
        Index pkReplacement = table.mutator().addNewIndex();
        String idxName = SqliteMetadataHandlerImpl.md5(oldPks.toString());
        IndexMutator mutator = pkReplacement.mutator();
        mutator.setId(idxName);
        mutator.setName(idxName);
        mutator.setUnique(Boolean.valueOf(true));
        table.primaryKeyColumns().forEachOrdered(pkc -> {
            int ordNo = 1 + (int)pkReplacement.indexColumns().count();
            IndexColumn idxCol = mutator.addNewIndexColumn();
            idxCol.mutator().setId(pkc.getId());
            idxCol.mutator().setName(pkc.getName());
            idxCol.mutator().setOrdinalPosition(Integer.valueOf(ordNo));
        });
    }

    private void columns(Connection conn, Map<String, Class<?>> sqlTypeMapping, Table table, ProgressMeasure progress) {
        NullUtil.requireNonNulls((Object)conn, sqlTypeMapping, (Object)table, (Object)progress);
        SqlSupplier supplier = () -> conn.getMetaData().getColumns(null, null, table.getId(), null);
        TableChildMutator<Column> mutator = (column, rs) -> {
            ColumnMetaData md = ColumnMetaData.of((ResultSet)rs);
            String columnName = md.getColumnName();
            column.getData().put(ORIGINAL_TYPE, md.getTypeName());
            column.mutator().setId(columnName);
            column.mutator().setName(columnName);
            column.mutator().setOrdinalPosition(Integer.valueOf(md.getOrdinalPosition()));
            column.mutator().setNullable(Boolean.valueOf(MetaDataUtil.isNullable(md)));
            column.mutator().setDatabaseType(this.typeMappingHelper.findFor(sqlTypeMapping, md).orElseGet(() -> {
                LOGGER.warn(String.format("Unable to determine mapping for table %s, column %s. Type name %s, data type %d, decimal digits %d. Fallback to JDBC-type %s", table.getId(), column.getId(), md.getTypeName(), md.getDataType(), md.getDecimalDigits(), Object.class.getName()));
                return Object.class;
            }));
            if (!md.isDecimalDigitsNull() && md.getDecimalDigits() != 10) {
                column.mutator().setDecimalDigits(Integer.valueOf(md.getDecimalDigits()));
            }
            if (!md.isColumnSizeNull() && md.getColumnSize() != 2000000000) {
                column.mutator().setColumnSize(Integer.valueOf(md.getColumnSize()));
            }
            if (MetaDataUtil.isAutoIncrement(md)) {
                column.mutator().setAutoIncrement(Boolean.valueOf(true));
            }
            if (!column.isNullable() && MetaDataUtil.isWrapper(column.findDatabaseType())) {
                column.mutator().setTypeMapper(TypeMapper.primitive().getClass());
            }
            if ("ENUM".equalsIgnoreCase(md.getTypeName())) {
                Dbms dbms = (Dbms)DocumentUtil.ancestor((Document)table, Dbms.class).get();
                List<String> constants = this.enumConstantsOf(dbms, table, columnName);
                column.mutator().setEnumConstants(constants.stream().collect(Collectors.joining(",")));
            }
            progress.setCurrentAction(LoggingUtil.describe(column));
        };
        this.tableChilds(table, Column.class, () -> ((TableMutator)table.mutator()).addNewColumn(), (SqlSupplier<ResultSet>)supplier, (SqlFunction<ResultSet, String>)((SqlFunction)rsChild -> ColumnMetaData.of((ResultSet)rsChild).getColumnName()), mutator);
    }

    private void primaryKeyColumns(Connection conn, Table table, ProgressMeasure progress) {
        NullUtil.requireNonNulls((Object)conn, (Object)table, (Object)progress);
        SqlSupplier supplier = () -> conn.getMetaData().getPrimaryKeys(null, null, table.getId());
        TableChildMutator<PrimaryKeyColumn> mutator = (pkc, rs) -> {
            String columnName = rs.getString(COLUMN_NAME);
            pkc.mutator().setId(columnName);
            pkc.mutator().setName(columnName);
            pkc.mutator().setOrdinalPosition(Integer.valueOf(rs.getInt(KEY_SEQ)));
        };
        this.tableChilds(table, PrimaryKeyColumn.class, () -> ((TableMutator)table.mutator()).addNewPrimaryKeyColumn(), (SqlSupplier<ResultSet>)supplier, (SqlFunction<ResultSet, String>)((SqlFunction)rsChild -> rsChild.getString(COLUMN_NAME)), mutator);
        if (!table.isView() && table.primaryKeyColumns().noneMatch(pk -> true)) {
            LOGGER.warn(String.format("Table '%s' does not have any primary key.", table.getId()));
        }
    }

    private void indexes(Connection conn, Table table, ProgressMeasure progress) {
        NullUtil.requireNonNulls((Object)conn, (Object)table, (Object)progress);
        if (table.isView()) {
            // empty if block
        }
        SqlSupplier supplier = () -> conn.getMetaData().getIndexInfo(null, null, table.getId(), false, true);
        TableChildMutator<Index> mutator = (index, rs) -> {
            String indexName = rs.getString(INDEX_NAME);
            index.mutator().setId(indexName);
            index.mutator().setName(indexName);
            index.mutator().setUnique(Boolean.valueOf(!rs.getBoolean("NON_UNIQUE")));
            IndexColumn indexColumn = index.mutator().addNewIndexColumn();
            String columnName = rs.getString(COLUMN_NAME);
            indexColumn.mutator().setId(columnName);
            indexColumn.mutator().setName(columnName);
            indexColumn.mutator().setOrdinalPosition(Integer.valueOf(rs.getInt("ORDINAL_POSITION")));
            indexColumn.mutator().setOrderType(MetaDataUtil.getOrderType(rs));
        };
        SqlPredicate filter = rs -> rs.getString(INDEX_NAME) != null;
        this.tableChilds(table, Index.class, () -> ((TableMutator)table.mutator()).addNewIndex(), (SqlSupplier<ResultSet>)supplier, (SqlFunction<ResultSet, String>)((SqlFunction)rsChild -> rsChild.getString(INDEX_NAME)), mutator, (SqlPredicate<ResultSet>)filter);
    }

    private void foreignKeys(Connection conn, Table table) {
        NullUtil.requireNonNulls((Object)conn, (Object)table);
        Schema schema = (Schema)table.getParentOrThrow();
        SqlSupplier supplier = () -> conn.getMetaData().getImportedKeys(null, null, table.getId());
        LinkedHashSet fksThatNeedNewNames = new LinkedHashSet();
        TableChildMutator<ForeignKey> mutator = (foreignKey, rs) -> {
            String foreignKeyName = rs.getString("FK_NAME");
            if (foreignKeyName == null || foreignKeyName.trim().isEmpty()) {
                if (rs.getInt(KEY_SEQ) == 1) {
                    String uniqueName = UUID.randomUUID().toString();
                    foreignKey.mutator().setId(uniqueName);
                    foreignKey.mutator().setName(uniqueName);
                    fksThatNeedNewNames.add(uniqueName);
                }
            } else {
                foreignKey.mutator().setId(foreignKeyName);
                foreignKey.mutator().setName(foreignKeyName);
            }
            ForeignKeyColumn foreignKeyColumn = foreignKey.mutator().addNewForeignKeyColumn();
            ForeignKeyColumnMutator fkcMutator = foreignKeyColumn.mutator();
            String fkColumnName = rs.getString("FKCOLUMN_NAME");
            fkcMutator.setId(fkColumnName);
            fkcMutator.setName(fkColumnName);
            fkcMutator.setOrdinalPosition(Integer.valueOf(rs.getInt(KEY_SEQ)));
            fkcMutator.setForeignTableName(rs.getString("PKTABLE_NAME"));
            fkcMutator.setForeignColumnName(rs.getString("PKCOLUMN_NAME"));
            fkcMutator.setForeignDatabaseName(((Dbms)schema.getParentOrThrow()).getId());
            fkcMutator.setForeignSchemaName(SCHEMA);
        };
        this.tableChilds(table, ForeignKey.class, () -> ((TableMutator)table.mutator()).addNewForeignKey(), (SqlSupplier<ResultSet>)supplier, (SqlFunction<ResultSet, String>)((SqlFunction)rsChild -> rsChild.getInt(KEY_SEQ) == 1 ? "" : (String)fksThatNeedNewNames.stream().skip((long)fksThatNeedNewNames.size() - 1L).findFirst().orElseThrow(IllegalStateException::new)), mutator);
        table.foreignKeys().filter(fk -> fksThatNeedNewNames.contains(fk.getId())).forEach(fk -> {
            Set thisSet = fk.foreignKeyColumns().map(HasId::getId).collect(Collectors.toSet());
            Optional<Index> found = table.indexes().filter(idx -> idx.indexColumns().map(HasId::getId).collect(Collectors.toSet()).equals(thisSet)).findFirst();
            if (found.isPresent()) {
                fk.mutator().setId(found.get().getId());
                fk.mutator().setName(found.get().getName());
            } else {
                String randName = SqliteMetadataHandlerImpl.md5(thisSet.toString());
                fk.mutator().setId(randName);
                fk.mutator().setName(randName);
                LOGGER.error(String.format("Found a foreign key in table '%s' with no name. Assigning it a random name '%s'", table.getId(), randName));
            }
        });
    }

    private static String md5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] mdbytes = md.digest(str.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte mdbyte : mdbytes) {
                sb.append(Integer.toString((mdbyte & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("MD5 algorithm not supported.", ex);
        }
    }

    private <T extends Document & HasId> void tableChilds(Table table, Class<T> childType, Supplier<T> childSupplier, SqlSupplier<ResultSet> resultSetSupplier, SqlFunction<ResultSet, String> childIdGetter, TableChildMutator<T> resultSetMutator) {
        this.tableChilds(table, childType, childSupplier, resultSetSupplier, childIdGetter, resultSetMutator, (SqlPredicate<ResultSet>)((SqlPredicate)rs -> true));
    }

    private <T extends Document & HasId> void tableChilds(Table table, Class<T> childType, Supplier<T> childSupplier, SqlSupplier<ResultSet> resultSetSupplier, SqlFunction<ResultSet, String> childIdGetter, TableChildMutator<T> resultSetMutator, SqlPredicate<ResultSet> filter) {
        NullUtil.requireNonNulls(childSupplier, resultSetSupplier, resultSetMutator);
        try (ResultSet rsChild = (ResultSet)resultSetSupplier.get();){
            while (rsChild.next()) {
                if (filter.test((Object)rsChild)) {
                    String id = (String)childIdGetter.apply((Object)rsChild);
                    Optional<Document> existing = DocumentDbUtil.typedChildrenOf((Table)table).filter(childType::isInstance).map(childType::cast).filter(idx -> id.equals(((HasId)idx).getId())).findAny();
                    Document child = existing.orElseGet(childSupplier);
                    resultSetMutator.mutate(child, rsChild);
                    continue;
                }
                LOGGER.info("Skipped due to RS filtering. This is normal for some DBMS types.");
            }
        }
        catch (SQLException sqle) {
            LOGGER.error((Throwable)sqle, "Unable to read table child.");
            throw new SpeedmentException((Throwable)sqle);
        }
    }

    private List<String> enumConstantsOf(Dbms dbms, Table table, String columnName) throws SQLException {
        SqliteNamingConvention naming = new SqliteNamingConvention();
        String sql = String.format("show columns from %s where field=%s;", naming.fullNameOf(table), naming.quoteField(columnName));
        try (PoolableConnection conn = this.connectionPool.getConnection(dbms);
             PreparedStatement ps = conn.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                String fullResult = rs.getString(2);
                if (fullResult.startsWith("enum('") && fullResult.endsWith("')")) {
                    String middle = fullResult.substring(5, fullResult.length() - 1);
                    List<String> list = Stream.of(middle.split(",")).map(s -> s.substring(1, s.length() - 1)).filter(s -> !s.isEmpty()).collect(Collectors.toList());
                    return list;
                }
                throw new SpeedmentException("Unexpected response (" + fullResult + ").");
            }
            throw new SpeedmentException("Expected an result.");
        }
    }

    @FunctionalInterface
    protected static interface TableChildMutator<T> {
        public void mutate(T var1, ResultSet var2) throws SQLException;
    }
}

