/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.connector.sqlite.internal;

import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.ExecuteBefore;
import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.connector.sqlite.SqliteOperationHandler;
import com.speedment.runtime.core.component.connectionpool.ConnectionPoolComponent;
import com.speedment.runtime.core.component.transaction.TransactionComponent;
import com.speedment.runtime.core.db.AsynchronousQueryResult;
import com.speedment.runtime.core.db.DbmsOperationHandler;
import com.speedment.runtime.core.db.DbmsOperationalHandlerBuilder;
import com.speedment.runtime.core.db.SqlFunction;
import com.speedment.runtime.core.stream.parallel.ParallelStrategy;
import com.speedment.runtime.field.Field;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

public final class SqliteOperationHandlerImpl
implements SqliteOperationHandler {
    private final DbmsOperationHandler inner;

    public SqliteOperationHandlerImpl(ConnectionPoolComponent connectionPoolComponent, TransactionComponent transactionComponent) {
        this.inner = DbmsOperationalHandlerBuilder.create((ConnectionPoolComponent)connectionPoolComponent, (TransactionComponent)transactionComponent).build();
    }

    @ExecuteBefore(value=State.STOPPED)
    public void close() {
        this.inner.close();
    }

    public <T> Stream<T> executeQuery(Dbms dbms, String sql, List<?> values, SqlFunction<ResultSet, T> rsMapper) {
        return this.inner.executeQuery(dbms, sql, values, rsMapper);
    }

    public <T> AsynchronousQueryResult<T> executeQueryAsync(Dbms dbms, String sql, List<?> values, SqlFunction<ResultSet, T> rsMapper, ParallelStrategy parallelStrategy) {
        return this.inner.executeQueryAsync(dbms, sql, values, rsMapper, parallelStrategy);
    }

    public <ENTITY> void executeInsert(Dbms dbms, String sql, List<?> values, Collection<Field<ENTITY>> generatedKeyFields, Consumer<List<Long>> generatedKeyConsumer) throws SQLException {
        this.inner.executeInsert(dbms, sql, values, generatedKeyFields, generatedKeyConsumer);
    }

    public void executeUpdate(Dbms dbms, String sql, List<?> values) throws SQLException {
        this.inner.executeUpdate(dbms, sql, values);
    }

    public void executeDelete(Dbms dbms, String sql, List<?> values) throws SQLException {
        this.inner.executeDelete(dbms, sql, values);
    }

    public Clob createClob(Dbms dbms) throws SQLException {
        return this.inner.createClob(dbms);
    }

    public Blob createBlob(Dbms dbms) throws SQLException {
        return this.inner.createBlob(dbms);
    }

    public NClob createNClob(Dbms dbms) throws SQLException {
        return this.inner.createNClob(dbms);
    }

    public SQLXML createSQLXML(Dbms dbms) throws SQLException {
        return this.inner.createSQLXML(dbms);
    }

    public Array createArray(Dbms dbms, String typeName, Object[] elements) throws SQLException {
        return this.inner.createArray(dbms, typeName, elements);
    }

    public Struct createStruct(Dbms dbms, String typeName, Object[] attributes) throws SQLException {
        return this.inner.createStruct(dbms, typeName, attributes);
    }

    public <T> Stream<T> executeQuery(Dbms dbms, String sql, SqlFunction<ResultSet, T> rsMapper) {
        return this.inner.executeQuery(dbms, sql, rsMapper);
    }

    public void configureSelect(PreparedStatement statement) throws SQLException {
        this.inner.configureSelect(statement);
    }

    public void configureSelect(ResultSet resultSet) throws SQLException {
        this.inner.configureSelect(resultSet);
    }
}

