/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.connector.sqlite.internal.types;

import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.connector.sqlite.internal.types.SqlTypeMappingHelper;
import com.speedment.runtime.core.component.DbmsHandlerComponent;
import com.speedment.runtime.core.component.connectionpool.ConnectionPoolComponent;
import com.speedment.runtime.core.component.connectionpool.PoolableConnection;
import com.speedment.runtime.core.db.DbmsType;
import com.speedment.runtime.core.db.JavaTypeMap;
import com.speedment.runtime.core.db.metadata.ColumnMetaData;
import com.speedment.runtime.core.db.metadata.TypeInfoMetaData;
import com.speedment.runtime.core.exception.SpeedmentException;
import com.speedment.runtime.core.util.CaseInsensitiveMaps;
import com.speedment.runtime.core.util.DatabaseUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public final class SqlTypeMappingHelperImpl
implements SqlTypeMappingHelper {
    private final ConnectionPoolComponent connectionPool;
    private final DbmsHandlerComponent dbmsHandler;
    private final JavaTypeMap javaTypeMap;

    SqlTypeMappingHelperImpl(ConnectionPoolComponent connectionPool, DbmsHandlerComponent dbmsHandler, JavaTypeMap javaTypeMap) {
        this.connectionPool = Objects.requireNonNull(connectionPool);
        this.dbmsHandler = Objects.requireNonNull(dbmsHandler);
        this.javaTypeMap = Objects.requireNonNull(javaTypeMap);
    }

    @Override
    public CompletableFuture<Map<String, Class<?>>> loadFor(Dbms dbms) {
        DbmsType dbmsType = DatabaseUtil.dbmsTypeOf((DbmsHandlerComponent)this.dbmsHandler, (Dbms)dbms);
        Set preSet = dbmsType.getDataTypes();
        return CompletableFuture.supplyAsync(() -> {
            Map<String, Class<?>> sqlTypeMapping;
            try {
                sqlTypeMapping = !preSet.isEmpty() ? this.readTypeMapFromSet(preSet) : this.readTypeMapFromDB(dbms);
            }
            catch (SQLException ex) {
                throw new SpeedmentException("Error loading type map from database.", (Throwable)ex);
            }
            return sqlTypeMapping;
        });
    }

    @Override
    public Optional<Class<?>> findFor(Map<String, Class<?>> loaded, ColumnMetaData metaData) {
        return Optional.ofNullable(this.javaTypeMap.findJdbcType(loaded, metaData));
    }

    private Map<String, Class<?>> readTypeMapFromSet(Set<TypeInfoMetaData> typeInfos) {
        return this.typeMapFromTypeInfo(new ArrayList<TypeInfoMetaData>(typeInfos));
    }

    private Map<String, Class<?>> readTypeMapFromDB(Dbms dbms) throws SQLException {
        Objects.requireNonNull(dbms);
        ArrayList<TypeInfoMetaData> typeInfoMetaDataList = new ArrayList<TypeInfoMetaData>();
        try (PoolableConnection connection = this.connectionPool.getConnection(dbms);){
            try (ResultSet rs = connection.getMetaData().getTypeInfo();){
                while (rs.next()) {
                    TypeInfoMetaData typeInfo = TypeInfoMetaData.of((ResultSet)rs);
                    typeInfoMetaDataList.add(typeInfo);
                }
            }
            Map<String, Class<?>> map = this.typeMapFromTypeInfo(typeInfoMetaDataList);
            return map;
        }
    }

    private Map<String, Class<?>> typeMapFromTypeInfo(List<TypeInfoMetaData> typeInfoMetaDataList) {
        Objects.requireNonNull(typeInfoMetaDataList);
        Map result = CaseInsensitiveMaps.newCaseInsensitiveMap();
        typeInfoMetaDataList.forEach(ti -> {
            Optional javaSqlTypeName = ti.javaSqlTypeName();
            javaSqlTypeName.ifPresent(tn -> {
                Class mappedClass = this.javaTypeMap.get(tn);
                if (mappedClass != null) {
                    result.put(tn, mappedClass);
                }
            });
        });
        typeInfoMetaDataList.forEach(ti -> {
            String key = ti.getSqlTypeName();
            Class mappedClass = this.javaTypeMap.get(key);
            if (mappedClass != null) {
                result.put(key, mappedClass);
            } else {
                Optional javaSqlTypeName = ti.javaSqlTypeName();
                javaSqlTypeName.ifPresent(ltn -> {
                    Class lookupMappedClass = this.javaTypeMap.get(ltn);
                    if (lookupMappedClass != null) {
                        result.put(key, lookupMappedClass);
                    }
                });
            }
        });
        return result;
    }
}

