/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.connector.sqlite.internal.util;

import com.speedment.runtime.config.parameter.OrderType;
import com.speedment.runtime.core.db.metadata.ColumnMetaData;
import com.speedment.runtime.core.exception.SpeedmentException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class MetaDataUtil {
    public static boolean isNullable(ColumnMetaData metaData) {
        switch (metaData.getNullable()) {
            case 1: 
            case 2: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        throw new SpeedmentException("Unknown nullable type " + metaData.getNullable());
    }

    public static OrderType getOrderType(ResultSet rsIndex) throws SQLException {
        String ascOrDesc = rsIndex.getString("ASC_OR_DESC");
        if ("A".equalsIgnoreCase(ascOrDesc)) {
            return OrderType.ASC;
        }
        if ("D".equalsIgnoreCase(ascOrDesc)) {
            return OrderType.DESC;
        }
        return OrderType.NONE;
    }

    public static boolean isAutoIncrement(ColumnMetaData metaData) {
        return "YES".equalsIgnoreCase(metaData.getIsAutoincrement()) || "YES".equalsIgnoreCase(metaData.getIsGeneratedcolumn());
    }

    public static boolean isWrapper(Class<?> type) {
        return type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == Character.class || type == Boolean.class;
    }

    private MetaDataUtil() {
    }
}

