/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.Preconditions;
import java.io.File;
import java.io.Serializable;

public final class HeapDump
implements Serializable {
    public final File heapDumpFile;
    public final String referenceKey;
    public final String referenceName;
    public final long watchDurationMs;
    public final long gcDurationMs;
    public final long heapDumpDurationMs;

    public HeapDump(File heapDumpFile, String referenceKey, String referenceName, long watchDurationMs, long gcDurationMs, long heapDumpDurationMs) {
        this.heapDumpFile = Preconditions.checkNotNull(heapDumpFile, "heapDumpFile");
        this.referenceKey = Preconditions.checkNotNull(referenceKey, "referenceKey");
        this.referenceName = Preconditions.checkNotNull(referenceName, "referenceName");
        this.watchDurationMs = watchDurationMs;
        this.gcDurationMs = gcDurationMs;
        this.heapDumpDurationMs = heapDumpDurationMs;
    }

    public HeapDump renameFile(File newFile) {
        this.heapDumpFile.renameTo(newFile);
        return new HeapDump(newFile, this.referenceKey, this.referenceName, this.watchDurationMs, this.gcDurationMs, this.heapDumpDurationMs);
    }

    public static interface Listener {
        public void analyze(HeapDump var1);
    }
}

