/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report;

import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.enums.RV;
import java.math.BigDecimal;
import java.util.List;

public class Func {

    public static class EngineHelper {
        public static String joinColumnContent(StiDataSource dataSource, String columnName, String delimiter) {
            StringBuilder sb = new StringBuilder();
            if (!dataSource.isEmpty()) {
                dataSource.saveState("JoinColumnContent");
                dataSource.First();
                int index = 0;
                while (!dataSource.getIsEof()) {
                    sb.append(dataSource.get(columnName).toString());
                    if (index < dataSource.size() - 1) {
                        sb.append(delimiter);
                    }
                    ++index;
                    dataSource.Next();
                }
                dataSource.RestoreState("JoinColumnContent");
            }
            return sb.toString();
        }

        public static String toQueryString(List<?> list, String quotationMark, String dateTimeFormat) {
            StringBuilder sb = new StringBuilder();
            int index = 0;
            for (Object obj : list) {
                if (index > 0) {
                    sb.append(", ");
                }
                String st = StiValidationUtil.isNullOrEmpty((String)dateTimeFormat) && !(obj instanceof StiDateTime) ? obj.toString() : ((StiDateTime)obj).format(dateTimeFormat);
                if (!StiValidationUtil.isNullOrEmpty((String)quotationMark)) {
                    st = st.replace(quotationMark, quotationMark + quotationMark);
                }
                sb.append(quotationMark + st + quotationMark);
                ++index;
            }
            return sb.toString();
        }
    }

    public static class Convert {
        private static int[] Arabics = new int[]{1, 5, 10, 50, 100, 1000};
        private static char[] Romans = new char[]{'I', 'V', 'X', 'L', 'C', 'M'};
        private static int[] Subs = new int[]{0, 0, 0, 2, 2, 4};
        private static char[] ABC = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        private static char[] ABCRu = new char[]{'\u0410', '\u0411', '\u0412', '\u0413', '\u0414', '\u0415', '\u0416', '\u0417', '\u0418', '\u041a', '\u041b', '\u041c', '\u041d', '\u041e', '\u041f', '\u0420', '\u0421', '\u0422', '\u0423', '\u0424', '\u0425', '\u0426', '\u0427', '\u0428', '\u0429', '\u042d', '\u042e', '\u042f'};

        public static String toRoman(int value) {
            StringBuilder str = new StringBuilder();
            block0: while (value > 0) {
                for (int i = 5; i >= 0; --i) {
                    if (value >= Arabics[i]) {
                        str.append(Romans[i]);
                        value -= Arabics[i];
                        continue block0;
                    }
                    boolean flag = false;
                    for (int j = Subs[i]; j < i; ++j) {
                        if (Arabics[j] == Arabics[i] - Arabics[j] || value < Arabics[i] - Arabics[j]) continue;
                        str.append(Romans[j]);
                        str.append(Romans[i]);
                        value -= Arabics[i] - Arabics[j];
                        flag = true;
                        break;
                    }
                    if (flag) continue block0;
                }
            }
            return str.toString();
        }

        public static String toArabic(int value, Boolean useEasternDigits) {
            return Convert.toArabic(String.valueOf(value), useEasternDigits);
        }

        public static String toArabic(String value, Boolean useEasternDigits) {
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < value.length(); ++index) {
                int num = value.charAt(index);
                if (num >= 48 && num <= 57) {
                    num += 1584;
                    if (useEasternDigits.booleanValue()) {
                        num += 144;
                    }
                }
                sb.append((char)num);
            }
            return sb.toString();
        }
    }

    public static class Ua {
        private static String[] months = new String[]{"\u0441\u0456\u0447\u043d\u044f", "\u043b\u044e\u0442\u043e\u0433\u043e", "\u0431\u0435\u0440\u0435\u0437\u043d\u044f", "\u043a\u0432\u0456\u0442\u043d\u044f", "\u0442\u0440\u0430\u0432\u043d\u044f", "\u0447\u0435\u0440\u0432\u043d\u044f", "\u043b\u0438\u043f\u043d\u044f", "\u0441\u0435\u0440\u043f\u043d\u044f", "\u0432\u0435\u0440\u0435\u0441\u043d\u044f", "\u0436\u043e\u0432\u0442\u043d\u044f", "\u043b\u0438\u0441\u0442\u043e\u043f\u0430\u0434\u0430", "\u0433\u0440\u0443\u0434\u043d\u044f"};
        private static String[] units = new String[]{"\u043e\u0434\u0438\u043d", "\u0434\u0432\u0430", "\u0442\u0440\u0438", "\u0447\u043e\u0442\u0438\u0440\u0438", "\u043f'\u044f\u0442\u044c", "\u0448\u0456\u0441\u0442\u044c", "\u0441\u0456\u043c", "\u0432\u0456\u0441\u0456\u043c", "\u0434\u0435\u0432'\u044f\u0442\u044c", "\u0434\u0435\u0441\u044f\u0442\u044c", "\u043e\u0434\u0438\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0434\u0432\u0430\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0447\u043e\u0442\u0438\u0440\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u043f'\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0448\u0456\u0441\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0441\u0456\u043c\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0432\u0456\u0441\u0456\u043c\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0434\u0435\u0432'\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c"};
        private static String[] tens = new String[]{"\u0434\u0435\u0441\u044f\u0442\u044c", "\u0434\u0432\u0430\u0434\u0446\u044f\u0442\u044c", "\u0442\u0440\u0438\u0434\u0446\u044f\u0442\u044c", "\u0441\u043e\u0440\u043e\u043a", "\u043f'\u044f\u0442\u0434\u0435\u0441\u044f\u0442", "\u0448\u0456\u0441\u0442\u0434\u0435\u0441\u044f\u0442", "\u0441\u0456\u043c\u0434\u0435\u0441\u044f\u0442", "\u0432\u0456\u0441\u0456\u043c\u0434\u0435\u0441\u044f\u0442", "\u0434\u0435\u0432'\u044f\u043d\u043e\u0441\u0442\u043e"};
        private static String[] hundreds = new String[]{"\u0441\u0442\u043e", "\u0434\u0432\u0456\u0441\u0442\u0456", "\u0442\u0440\u0438\u0441\u0442\u0430", "\u0447\u043e\u0442\u0438\u0440\u0438\u0441\u0442\u0430", "\u043f'\u044f\u0442\u0441\u043e\u0442", "\u0448\u0456\u0441\u0442\u0441\u043e\u0442", "\u0441\u0456\u043c\u0441\u043e\u0442", "\u0432\u0456\u0441\u0456\u043c\u0441\u043e\u0442", "\u0434\u0435\u0432'\u044f\u0442\u0441\u043e\u0442"};
        private static String[][] gendered = new String[][]{{"\u043e\u0434\u0438\u043d", "\u043e\u0434\u043d\u0430", "\u043e\u0434\u043d\u0435"}, {"\u0434\u0432\u0430", "\u0434\u0432\u0456", "\u0434\u0432\u0430"}};

        private static void addUnits(StringBuilder sb, BigDecimal value, int gender) {
            if (value.signum() != 0) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                if (value.compareTo(new BigDecimal("3")) < 0) {
                    sb.append(gendered[value.intValue() - 1][gender]);
                } else {
                    sb.append(units[value.intValue() - 1]);
                }
            }
        }

        private static void addTens(StringBuilder sb, BigDecimal value) {
            if (value.signum() != 0) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(tens[value.intValue() - 1]);
            }
        }

        private static void addHundreds(StringBuilder sb, BigDecimal value) {
            if (value.signum() != 0) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(hundreds[value.intValue() - 1]);
            }
        }

        private static void addThousand(StringBuilder sb, BigDecimal value, int gender) {
            Ua.addHundreds(sb, value.divideToIntegralValue(new BigDecimal("100")));
            value = value.remainder(new BigDecimal(100));
            if (value.compareTo(new BigDecimal("20")) < 0) {
                Ua.addUnits(sb, value, gender);
            } else {
                Ua.addTens(sb, value.divideToIntegralValue(new BigDecimal("10")));
                Ua.addUnits(sb, value.remainder(new BigDecimal("10")), gender);
            }
        }

        private static RV addRank(StringBuilder sb, RV rv, String one, String two, String five, int gender) {
            BigDecimal rankValue = rv.value.divideToIntegralValue(rv.rank);
            if (rankValue.signum() > 0) {
                Ua.addThousand(sb, rankValue, gender);
                BigDecimal units = rankValue.remainder(new BigDecimal("10"));
                BigDecimal units2 = rankValue.remainder(new BigDecimal("100"));
                String unit = "";
                unit = units2.compareTo(new BigDecimal("11")) >= 0 && units2.compareTo(new BigDecimal("20")) < 0 ? five : (units.compareTo(new BigDecimal("1")) == 0 ? one : (units.compareTo(new BigDecimal("1")) > 0 && units.compareTo(new BigDecimal("5")) < 0 ? two : five));
                if (rankValue.compareTo(new BigDecimal("10")) > 0 && rankValue.compareTo(new BigDecimal("20")) < 0) {
                    unit = five;
                }
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(unit);
                rv.value = rv.value.remainder(rv.rank);
            }
            rv.rank = rv.rank.divide(new BigDecimal(1000));
            return rv;
        }

        public static String numToStr(BigDecimal value, int gender) {
            return Ua.numToStr(value, false, gender);
        }

        public static String numToStr(BigDecimal value, Boolean uppercase, int gender) {
            StringBuilder sb = new StringBuilder();
            if (value.signum() == 0) {
                sb.append("\u043d\u043e\u043b\u044c");
            } else {
                if (value.signum() < 0) {
                    sb.append("\u043c\u0438\u043d\u0443\u0441");
                    value = value.abs();
                }
                BigDecimal rank = new BigDecimal("1000000000000000000");
                RV rv = new RV(rank, value);
                rv = Ua.addRank(sb, rv, "\u043a\u0432\u0456\u043d\u0442\u0438\u043b\u044c\u0439\u043e\u043d", "\u043a\u0432\u0456\u043d\u0442\u0438\u043b\u044c\u0439\u043e\u043d\u0430", "\u043a\u0432\u0456\u043d\u0442\u0438\u043b\u044c\u0439\u043e\u043d\u0456\u0432", 0);
                rv = Ua.addRank(sb, rv, "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u044c\u0439\u043e\u043d", "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u044c\u0439\u043e\u043d\u0430", "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u044c\u0439\u043e\u043d\u0456\u0432", 0);
                rv = Ua.addRank(sb, rv, "\u0442\u0440\u0438\u043b\u044c\u0439\u043e\u043d", "\u0442\u0440\u0438\u043b\u044c\u0439\u043e\u043d\u0430", "\u0442\u0440\u0438\u043b\u044c\u0439\u043e\u043d\u0456\u0432", 0);
                rv = Ua.addRank(sb, rv, "\u043c\u0456\u043b\u044c\u044f\u0440\u0434", "\u043c\u0456\u043b\u044c\u044f\u0440\u0434\u0430", "\u043c\u0456\u043b\u044c\u044f\u0440\u0434\u0456\u0432", 0);
                rv = Ua.addRank(sb, rv, "\u043c\u0456\u043b\u044c\u0439\u043e\u043d", "\u043c\u0456\u043b\u044c\u0439\u043e\u043d\u0430", "\u043c\u0456\u043b\u044c\u0439\u043e\u043d\u0456\u0432", 0);
                rv = Ua.addRank(sb, rv, "\u0442\u0438\u0441\u044f\u0447\u0430", "\u0442\u0438\u0441\u044f\u0447\u0456", "\u0442\u0438\u0441\u044f\u0447", 1);
                Ua.addThousand(sb, rv.value, gender);
            }
            if (uppercase.booleanValue()) {
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            }
            return sb.toString();
        }

        public static String dateToStr(StiDateTime date) {
            return Ua.dateToStr(date, false);
        }

        public static String dateToStr(StiDateTime date, Boolean uppercase) {
            StringBuilder sb = new StringBuilder(String.format("%s %s %s", date.get(5), months[date.get(2) - 1], date.get(1)));
            if (uppercase.booleanValue()) {
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            }
            return sb.toString();
        }
    }

    public static class Ru {
        private static String[] months = new String[]{"\u044f\u043d\u0432\u0430\u0440\u044f", "\u0444\u0435\u0432\u0440\u0430\u043b\u044f", "\u043c\u0430\u0440\u0442\u0430", "\u0430\u043f\u0440\u0435\u043b\u044f", "\u043c\u0430\u044f", "\u0438\u044e\u043d\u044f", "\u0438\u044e\u043b\u044f", "\u0430\u0432\u0433\u0443\u0441\u0442\u0430", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044f", "\u043e\u043a\u0442\u044f\u0431\u0440\u044f", "\u043d\u043e\u044f\u0431\u0440\u044f", "\u0434\u0435\u043a\u0430\u0431\u0440\u044f"};
        private static String[] units = new String[]{"\u043e\u0434\u0438\u043d", "\u0434\u0432\u0430", "\u0442\u0440\u0438", "\u0447\u0435\u0442\u044b\u0440\u0435", "\u043f\u044f\u0442\u044c", "\u0448\u0435\u0441\u0442\u044c", "\u0441\u0435\u043c\u044c", "\u0432\u043e\u0441\u0435\u043c\u044c", "\u0434\u0435\u0432\u044f\u0442\u044c", "\u0434\u0435\u0441\u044f\u0442\u044c", "\u043e\u0434\u0438\u043d\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0434\u0432\u0435\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0447\u0435\u0442\u044b\u0440\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u043f\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0432\u043e\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0434\u0435\u0432\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c"};
        private static String[] tens = new String[]{"\u0434\u0435\u0441\u044f\u0442\u044c", "\u0434\u0432\u0430\u0434\u0446\u0430\u0442\u044c", "\u0442\u0440\u0438\u0434\u0446\u0430\u0442\u044c", "\u0441\u043e\u0440\u043e\u043a", "\u043f\u044f\u0442\u044c\u0434\u0435\u0441\u044f\u0442", "\u0448\u0435\u0441\u0442\u044c\u0434\u0435\u0441\u044f\u0442", "\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442", "\u0432\u043e\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442", "\u0434\u0435\u0432\u044f\u043d\u043e\u0441\u0442\u043e"};
        private static String[] hundreds = new String[]{"\u0441\u0442\u043e", "\u0434\u0432\u0435\u0441\u0442\u0438", "\u0442\u0440\u0438\u0441\u0442\u0430", "\u0447\u0435\u0442\u044b\u0440\u0435\u0441\u0442\u0430", "\u043f\u044f\u0442\u044c\u0441\u043e\u0442", "\u0448\u0435\u0441\u0442\u044c\u0441\u043e\u0442", "\u0441\u0435\u043c\u044c\u0441\u043e\u0442", "\u0432\u043e\u0441\u0435\u043c\u044c\u0441\u043e\u0442", "\u0434\u0435\u0432\u044f\u0442\u044c\u0441\u043e\u0442"};
        private static String[][] gendered = new String[][]{{"\u043e\u0434\u0438\u043d", "\u043e\u0434\u043d\u0430", "\u043e\u0434\u043d\u043e"}, {"\u0434\u0432\u0430", "\u0434\u0432\u0435", "\u0434\u0432\u0430"}};

        public static String numToStr(BigDecimal value, int gender) {
            return Ru.numToStr(value, false, gender);
        }

        public static String numToStr(BigDecimal value, Boolean uppercase, int gender) {
            StringBuilder sb = new StringBuilder();
            if (value.signum() == 0) {
                sb.append("\u043d\u043e\u043b\u044c");
            } else {
                if (value.signum() < 0) {
                    sb.append("\u043c\u0438\u043d\u0443\u0441");
                    value = value.abs();
                }
                BigDecimal rank = new BigDecimal("1000000000000000000");
                RV rv = new RV(rank, value);
                rv = Ru.addRank(sb, rv, "\u043a\u0432\u0438\u043d\u0442\u0438\u043b\u044c\u043e\u043d", "\u043a\u0432\u0438\u043d\u0442\u0438\u043b\u044c\u043e\u043d\u0430", "\u043a\u0432\u0438\u043d\u0442\u0438\u043b\u044c\u043e\u043d\u043e\u0432", 0);
                rv = Ru.addRank(sb, rv, "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u044c\u043e\u043d", "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u044c\u043e\u043d\u0430", "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u044c\u043e\u043d\u043e\u0432", 0);
                rv = Ru.addRank(sb, rv, "\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d", "\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u0430", "\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432", 0);
                rv = Ru.addRank(sb, rv, "\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434", "\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u0430", "\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u043e\u0432", 0);
                rv = Ru.addRank(sb, rv, "\u043c\u0438\u043b\u043b\u0438\u043e\u043d", "\u043c\u0438\u043b\u043b\u0438\u043e\u043d\u0430", "\u043c\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432", 0);
                rv = Ru.addRank(sb, rv, "\u0442\u044b\u0441\u044f\u0447\u0430", "\u0442\u044b\u0441\u044f\u0447\u0438", "\u0442\u044b\u0441\u044f\u0447", 1);
                Ru.addThousand(sb, rv.value, gender);
            }
            if (uppercase.booleanValue()) {
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            }
            return sb.toString();
        }

        private static void addUnits(StringBuilder sb, BigDecimal value, int gender) {
            if (value.signum() != 0) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                if (value.compareTo(new BigDecimal("3")) < 0) {
                    sb.append(gendered[value.intValue() - 1][gender]);
                } else {
                    sb.append(units[value.intValue() - 1]);
                }
            }
        }

        private static void addTens(StringBuilder sb, BigDecimal value) {
            if (value.signum() != 0) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(tens[value.intValue() - 1]);
            }
        }

        private static void addHundreds(StringBuilder sb, BigDecimal value) {
            if (value.signum() != 0) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(hundreds[value.intValue() - 1]);
            }
        }

        private static void addThousand(StringBuilder sb, BigDecimal value, int gender) {
            Ru.addHundreds(sb, value.divideToIntegralValue(new BigDecimal("100")));
            value = value.remainder(new BigDecimal(100));
            if (value.compareTo(new BigDecimal("20")) < 0) {
                Ru.addUnits(sb, value, gender);
            } else {
                Ru.addTens(sb, value.divideToIntegralValue(new BigDecimal("10")));
                Ru.addUnits(sb, value.remainder(new BigDecimal("10")), gender);
            }
        }

        private static RV addRank(StringBuilder sb, RV rv, String one, String two, String five, int gender) {
            BigDecimal rankValue = rv.value.divideToIntegralValue(rv.rank);
            if (rankValue.signum() > 0) {
                Ru.addThousand(sb, rankValue, gender);
                BigDecimal units = rankValue.remainder(new BigDecimal("10"));
                BigDecimal units2 = rankValue.remainder(new BigDecimal("100"));
                String unit = "";
                unit = units2.compareTo(new BigDecimal("11")) >= 0 && units2.compareTo(new BigDecimal("20")) < 0 ? five : (units.compareTo(new BigDecimal("1")) == 0 ? one : (units.compareTo(new BigDecimal("1")) > 0 && units.compareTo(new BigDecimal("5")) < 0 ? two : five));
                if (rankValue.compareTo(new BigDecimal("10")) > 0 && rankValue.compareTo(new BigDecimal("20")) < 0) {
                    unit = five;
                }
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(unit);
                rv.value = rv.value.remainder(rv.rank);
            }
            rv.rank = rv.rank.divide(new BigDecimal(1000));
            return rv;
        }
    }
}

