/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report;

import java.math.BigDecimal;
import java.util.Hashtable;

public class StiStatesManager {
    private static Object ValueBoolFalse = new Object();
    private static Object ValueBoolTrue = new Object();
    private final Hashtable states = new Hashtable();

    public final void Push(String stateName, Object obj, String property, Object value) {
        Hashtable<String, Object> properies;
        if (value == null) {
            return;
        }
        Hashtable<Object, Hashtable<String, Object>> objs = this.states.get(stateName) instanceof Hashtable ? this.states.get(stateName) : null;
        if (objs == null) {
            objs = new Hashtable<Object, Hashtable<String, Object>>();
            this.states.put(stateName, objs);
        }
        if ((properies = (Hashtable<String, Object>)(objs.get(obj) instanceof Hashtable ? objs.get(obj) : null)) == null) {
            properies = new Hashtable<String, Object>();
            objs.put(obj, properies);
        }
        properies.put(property, value);
    }

    public final void PushBool(String stateName, Object obj, String property, boolean value) {
        if (value) {
            this.Push(stateName, obj, property, ValueBoolTrue);
        } else {
            this.Push(stateName, obj, property, ValueBoolFalse);
        }
    }

    public final void PushInt(String stateName, Object obj, String property, int value) {
        this.Push(stateName, obj, property, new IntStorage(value));
    }

    public final void PushInt64(String stateName, Object obj, String property, long value) {
        this.Push(stateName, obj, property, new Int64Storage(value));
    }

    public final void PushFloat(String stateName, Object obj, String property, float value) {
        this.Push(stateName, obj, property, new FloatStorage(value));
    }

    public final void PushDouble(String stateName, Object obj, String property, double value) {
        this.Push(stateName, obj, property, new DoubleStorage(value));
    }

    public final void PushDecimal(String stateName, Object obj, String property, BigDecimal value) {
        this.Push(stateName, obj, property, new DecimalStorage(value));
    }

    public final Object Pop(String stateName, Object obj, String property) {
        Hashtable objs = this.states.get(stateName) instanceof Hashtable ? this.states.get(stateName) : null;
        if (objs == null) {
            return null;
        }
        Hashtable properties = objs.get(obj) instanceof Hashtable ? objs.get(obj) : null;
        if (properties == null) {
            return null;
        }
        return properties.get(property);
    }

    public final boolean PopBool(String stateName, Object obj, String property) {
        Object value = this.Pop(stateName, obj, property);
        return value != ValueBoolFalse;
    }

    public final int PopInt(String stateName, Object obj, String property) {
        Object tempVar = this.Pop(stateName, obj, property);
        IntStorage storage = (IntStorage)(tempVar instanceof IntStorage ? tempVar : null);
        if (storage == null) {
            return 0;
        }
        return storage.value;
    }

    public final long PopInt64(String stateName, Object obj, String property) {
        Object tempVar = this.Pop(stateName, obj, property);
        Int64Storage storage = (Int64Storage)(tempVar instanceof Int64Storage ? tempVar : null);
        if (storage == null) {
            return 0L;
        }
        return storage.value;
    }

    public final double PopDouble(String stateName, Object obj, String property) {
        Object tempVar = this.Pop(stateName, obj, property);
        DoubleStorage storage = (DoubleStorage)(tempVar instanceof DoubleStorage ? tempVar : null);
        if (storage == null) {
            return 0.0;
        }
        return storage.value;
    }

    public final float PopFloat(String stateName, Object obj, String property) {
        Object tempVar = this.Pop(stateName, obj, property);
        FloatStorage storage = (FloatStorage)(tempVar instanceof FloatStorage ? tempVar : null);
        if (storage == null) {
            return 0.0f;
        }
        return storage.value;
    }

    public final BigDecimal PopDecimal(String stateName, Object obj, String property) {
        Object tempVar = this.Pop(stateName, obj, property);
        DecimalStorage storage = (DecimalStorage)(tempVar instanceof DecimalStorage ? tempVar : null);
        if (storage == null) {
            return new BigDecimal(0);
        }
        return storage.value;
    }

    public final boolean IsExist(String stateName, Object obj) {
        if (this.states.get(stateName) == null) {
            return false;
        }
        Hashtable objs = this.states.get(stateName) instanceof Hashtable ? this.states.get(stateName) : null;
        return objs.get(obj) != null;
    }

    public final void Clear() {
        this.states.clear();
    }

    private static class DecimalStorage {
        public BigDecimal value = new BigDecimal(0);

        public DecimalStorage(BigDecimal value) {
            this.value = value;
        }
    }

    private static class Int64Storage {
        public long value;

        public Int64Storage(long value) {
            this.value = value;
        }
    }

    private static class DoubleStorage {
        public double value;

        public DoubleStorage(double value) {
            this.value = value;
        }
    }

    private static class FloatStorage {
        public float value;

        public FloatStorage(float value) {
            this.value = value;
        }
    }

    private static class IntStorage {
        public int value;

        public IntStorage(int value) {
            this.value = value;
        }
    }
}

