/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiCode128BarCodeType;
import java.util.ArrayList;

public class StiCode128cBarCodeType
extends StiCode128BarCodeType {
    public StiCode128cBarCodeType() {
        this(13.0, 1.0);
    }

    public StiCode128cBarCodeType(double module, double height) {
        super(module, height);
    }

    public String getServiceName() {
        return "Code128c";
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        code = this.CheckCodeSymbols(code, "0123456789\u0081");
        ArrayList<String> stringList = new ArrayList<String>();
        StringBuilder sbTemp = new StringBuilder();
        String st = "";
        for (char ch : code.toCharArray()) {
            if (ch == '\u0081') {
                stringList.add(st);
                st = "";
                sbTemp.append('\u2219');
                continue;
            }
            st = st + ch;
            sbTemp.append(ch);
        }
        if (st.length() > 0) {
            stringList.add(st);
        }
        if (stringList.isEmpty()) {
            stringList.add(st);
        }
        StringBuilder sbCode = new StringBuilder();
        for (int index = 0; index < stringList.size(); ++index) {
            String stLine = (String)stringList.get(index);
            int stringLen = stLine.length() / 2;
            for (int index2 = 0; index2 < stringLen; ++index2) {
                sbCode.append((char)Integer.parseInt(stLine.substring(index2 * 2, index2 * 2 + 2)));
            }
            if (stLine.length() % 2 == 1) {
                sbCode.append('d');
                sbCode.append((char)(stLine.charAt(stLine.length() - 1) - 32));
                if (index < stringList.size() - 1) {
                    sbCode.append('c');
                }
            }
            if (index >= stringList.size() - 1) continue;
            sbCode.append('f');
        }
        int[] fullCode = new int[sbCode.length() + 3];
        fullCode[0] = 105;
        for (int index = 0; index < sbCode.length(); ++index) {
            fullCode[index + 1] = sbCode.charAt(index);
        }
        int checkSum = fullCode[0];
        for (int index = 0; index < fullCode.length - 3; ++index) {
            checkSum += fullCode[index + 1] * (index + 1);
        }
        fullCode[fullCode.length - 2] = checkSum % 103;
        fullCode[fullCode.length - 1] = 106;
        StringBuilder barsArray = new StringBuilder();
        for (int index = 0; index < fullCode.length; ++index) {
            barsArray.append(this.CodeToBar(this.Code128Table[fullCode[index]]));
        }
        this.CalculateSizeFull(10.0, 10.0, 0.0, 1.0, 45.0, 45.0, 46.0, 8.33f, 55.0, 45.0, 2.0, zoom, code, sbTemp.toString(), barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public String getDefaultCodeValue() {
        return "0123456789012345";
    }
}

