/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiCode128BarCodeType;

public class StiEAN128aBarCodeType
extends StiCode128BarCodeType {
    public StiEAN128aBarCodeType() {
        this(13.0, 1.0);
    }

    public StiEAN128aBarCodeType(double module, double height) {
        super(module, height);
    }

    public String getServiceName() {
        return "EAN-128a";
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        code = this.CheckCodeSymbols(code, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\u0081");
        StringBuilder sbTemp = new StringBuilder();
        int[] fullCode = new int[code.length() + 4];
        fullCode[0] = 103;
        fullCode[1] = 102;
        int checkSum = fullCode[0] + fullCode[1];
        for (int index = 0; index < code.length(); ++index) {
            char ch = code.charAt(index);
            int n = fullCode[index + 2] = ch >= ' ' ? ch - 32 : ch + 64;
            if (ch == '\u0081') {
                fullCode[index + 2] = 102;
            }
            checkSum += fullCode[index + 2] * (index + 2);
            sbTemp.append(ch >= ' ' && ch != '\u0081' ? (char)ch : (char)'\u2219');
        }
        fullCode[fullCode.length - 2] = checkSum % 103;
        fullCode[fullCode.length - 1] = 106;
        StringBuilder barsArray = new StringBuilder();
        for (int index = 0; index < fullCode.length; ++index) {
            barsArray.append(this.CodeToBar(this.Code128Table[fullCode[index]]));
        }
        String text = sbTemp.toString();
        this.CalculateSizeFull(10.0, 10.0, 0.0, 1.0, 45.0, 45.0, 46.0, 8.33f, 55.0, 45.0, 2.0, zoom, code, text, barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public String getDefaultCodeValue() {
        return "ABC123";
    }
}

