/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiEAN8BarCodeType;
import com.stimulsoft.report.barCodes.enums.StiEanSupplementType;
import java.util.ArrayList;

public class StiJan8BarCodeType
extends StiEAN8BarCodeType {
    public StiJan8BarCodeType() {
        this(13.0, 1.0, StiEanSupplementType.None, null, true);
    }

    public StiJan8BarCodeType(double module, double height, StiEanSupplementType supplementType, String supplementCodeValue, boolean showQuietZoneIndicator) {
        super(module, height, supplementType, supplementCodeValue, showQuietZoneIndicator);
    }

    @Override
    public String getServiceName() {
        return "JAN-8";
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String fullCode = this.GetCode(barCode);
        String code = this.CheckCodeSymbols(fullCode, "0123456789") + "0000000000000";
        String suppCode = this.CheckCodeSymbols(this.getSupplementCode(), "0123456789") + "00000";
        if (!code.startsWith("45") && !code.startsWith("49")) {
            this.drawBarCodeError(context, rect, barCode);
            return;
        }
        ArrayList barsArray = null;
        if (this.getSupplementType() == StiEanSupplementType.None) {
            barsArray = this.MakeEan8Bars(code, true);
        } else {
            barsArray = this.MakeEan8Bars(code, false);
            if (this.getSupplementType() == StiEanSupplementType.TwoDigit) {
                this.MakeEanAdd2Bars(suppCode, barsArray, true);
            } else {
                this.MakeEanAdd5Bars(suppCode, barsArray, true);
            }
        }
        this.CalculateSizeEan(0.0, zoom, barsArray, rect, barCode);
        this.translateRect(context, rect, barCode);
        this.drawEanBars(context, barsArray, barCode);
        this.rollbackTransform(context);
    }

    @Override
    public String getDefaultCodeValue() {
        return "4523456789012";
    }
}

